/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.misc;

import com.sap.engine.library.bytecode.cf.CFException;
import com.sap.engine.library.bytecode.cf.CFFactory;
import com.sap.engine.library.bytecode.cf.ClassFile;
import com.sap.engine.library.bytecode.cf.MethodInfo;
import com.sap.engine.library.bytecode.misc.PropertiesTree;
import com.sap.engine.library.bytecode.misc.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public final class PackageSystemPropertiesTree {
    private final PropertiesTree tree = new PropertiesTree();
    private final ArrayList allPackageSystemIdentifiers = new ArrayList();
    private final Map hPathOfLabelsCache = new HashMap();

    public PackageSystemPropertiesTree() {
    }

    public PackageSystemPropertiesTree(Properties p) {
        this();
        Enumeration<?> enumeration = p.propertyNames();
        while (enumeration.hasMoreElements()) {
            String path = (String)enumeration.nextElement();
            String nameValuePairs = p.getProperty(path);
            String[] a = StringUtils.splitAndTrim(nameValuePairs, ',');
            int i = 0;
            while (i < a.length) {
                String value;
                String name;
                int indexOfEquals = a[i].indexOf(61);
                if (indexOfEquals == -1) {
                    name = a[i];
                    value = "";
                } else {
                    name = a[i].substring(0, indexOfEquals).trim();
                    value = a[i].substring(indexOfEquals + 1).trim();
                }
                this.put(path, name, value);
                ++i;
            }
        }
    }

    public void put(String packageSystemIdentifier, String propertyName, Object propertyValue) {
        String[] path = this.getPathOfLabels(packageSystemIdentifier);
        this.tree.put(path, propertyName, propertyValue);
        this.allPackageSystemIdentifiers.add(packageSystemIdentifier);
    }

    public Object get(String packageSystemIdentifier, String propertyName) {
        String[] path = this.getPathOfLabels(packageSystemIdentifier);
        return this.tree.get(path, propertyName);
    }

    public boolean hasDescendants(String packageSystemIdentifier) {
        String[] path = this.getPathOfLabels(packageSystemIdentifier);
        return this.tree.hasDescendants(path);
    }

    public String[] getAllPackageSystemIdentifiers() {
        return this.allPackageSystemIdentifiers.toArray(new String[this.allPackageSystemIdentifiers.size()]);
    }

    private String[] getPathOfLabels(String packageSystemIdentifier) {
        String[] r = (String[])this.hPathOfLabelsCache.get(packageSystemIdentifier);
        if (r == null) {
            r = StringUtils.packageSystemIdentifierToPathOfLabels(packageSystemIdentifier);
            this.hPathOfLabelsCache.put(packageSystemIdentifier, r);
        }
        return r;
    }

    public void checkAllPackageSystemIdentifiersExist(URL baseURL) throws IOException {
        String[] identifiers = this.getAllPackageSystemIdentifiers();
        int i = 0;
        while (i < identifiers.length) {
            String[] path = this.getPathOfLabels(identifiers[i]);
            if (path.length != 0) {
                String s = path[path.length - 1];
                if (s.startsWith("{class}")) {
                    String className = identifiers[i];
                    URL url = new URL(baseURL, className + ".class");
                    CFFactory.getThreadLocalInstance().createCFParser().parse(url.openStream(), null);
                } else if (s.startsWith("{method}")) {
                    int indexOfOpeningBracket;
                    int indexOfDot = identifiers[i].indexOf(46);
                    String className = identifiers[i].substring(0, indexOfDot);
                    URL url = new URL(baseURL, className + ".class");
                    ClassFile cf = CFFactory.getThreadLocalInstance().createCFParser().parse(url.openStream(), null);
                    MethodInfo method = cf.getMethod(identifiers[i].substring(indexOfDot + 1, indexOfOpeningBracket = identifiers[i].indexOf(40)), identifiers[i].substring(indexOfOpeningBracket));
                    if (method == null) {
                        throw new CFException(168, identifiers[i]);
                    }
                }
            }
            ++i;
        }
    }

    public ArrayList getErrorsAboutNonExistingEntries(URL[] baseURLs) {
        ArrayList<String> list = new ArrayList<String>();
        String[] identifiers = this.getAllPackageSystemIdentifiers();
        HashSet<String> processedIdentifiers = new HashSet<String>();
        int i = 0;
        while (i < identifiers.length) {
            block14: {
                String[] path;
                if (processedIdentifiers.add(identifiers[i]) && (path = this.getPathOfLabels(identifiers[i])).length != 0) {
                    String s = path[path.length - 1];
                    if (s.startsWith("{class}")) {
                        InputStream in = this.openStream(baseURLs, identifiers[i] + ".class");
                        if (in == null) {
                            list.add("Class '" + identifiers[i] + "' not found.");
                        } else {
                            try {
                                CFFactory.getThreadLocalInstance().createCFParser().parse(in, null);
                            }
                            catch (IOException e) {
                                list.add("Cannot parse class '" + identifiers[i] + "' - " + e);
                            }
                        }
                    } else if (s.startsWith("{method}")) {
                        int indexOfDot = identifiers[i].indexOf(46);
                        String className = identifiers[i].substring(0, indexOfDot);
                        InputStream in = this.openStream(baseURLs, className + ".class");
                        if (in == null) {
                            list.add("Class '" + identifiers[i] + "' not found.");
                        } else {
                            ClassFile cf = null;
                            try {
                                cf = CFFactory.getThreadLocalInstance().createCFParser().parse(in, null);
                            }
                            catch (IOException e) {
                                list.add("Cannot parse class '" + identifiers[i] + " - " + e);
                                break block14;
                            }
                            int indexOfOpeningBracket = identifiers[i].indexOf(40);
                            MethodInfo method = cf.getMethod(identifiers[i].substring(indexOfDot + 1, indexOfOpeningBracket), identifiers[i].substring(indexOfOpeningBracket));
                            if (method == null) {
                                list.add("Method " + identifiers[i] + " not found.");
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return list;
    }

    private InputStream openStream(URL[] baseURLs, String relativeName) {
        InputStream r = null;
        int i = 0;
        while (i < baseURLs.length) {
            try {
                r = new URL(baseURLs[i], relativeName).openStream();
                break;
            }
            catch (IOException e) {
                ++i;
            }
        }
        return r;
    }
}

