/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.misc;

import java.util.Arrays;

public final class ObjectIndexer {
    private static final int[] PRIMES = new int[]{17, 37, 67, 131, 257, 521, 1031, 2053, 4099, 8209, 16411, 32771, 65537, 131101, 262147, 524309, 0x100007, 0x200011, 0x40000F, 0x800009, 16777259, 0x2000023, 0x400000F, 134217757, 0x10000003, 0x2000000B, 0x40000003, Integer.MAX_VALUE};
    private static final double LOAD_FACTOR = 0.7;
    private static final int[] THRESHOLDS = new int[PRIMES.length];
    private int capacityIndexInPrimes = 0;
    private int capacity = PRIMES[this.capacityIndexInPrimes];
    private int nEntries = 0;
    private int threshold = THRESHOLDS[this.capacityIndexInPrimes];
    private Object[] keys = new Object[this.capacity];
    private int[] values = new int[this.capacity];
    private Object[] keysOrdered = new Object[128];

    public int getIndex(Object o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        int h = System.identityHashCode(o);
        int h2 = 8 - (h & 7);
        h %= this.capacity;
        while (true) {
            Object k;
            if ((k = this.keys[h]) == o) {
                return this.values[h];
            }
            if (k == null) break;
            h = (h + h2) % this.capacity;
        }
        this.keys[h] = o;
        this.values[h] = this.nEntries;
        if (this.keysOrdered.length == this.nEntries) {
            Object[] keysOrderedOld = this.keysOrdered;
            this.keysOrdered = new Object[keysOrderedOld.length * 2];
            System.arraycopy(keysOrderedOld, 0, this.keysOrdered, 0, this.nEntries);
        }
        this.keysOrdered[this.nEntries] = o;
        ++this.nEntries;
        if (this.nEntries >= this.threshold) {
            this.rehash();
        }
        return this.nEntries - 1;
    }

    public Object getObject(int index) {
        if (index < 0 || index >= this.nEntries) {
            throw new IllegalArgumentException();
        }
        return this.keysOrdered[index];
    }

    private void rehash() {
        Object[] keysOld = this.keys;
        int[] valuesOld = this.values;
        int capacityOld = this.capacity;
        ++this.capacityIndexInPrimes;
        this.capacity = PRIMES[this.capacityIndexInPrimes];
        this.threshold = THRESHOLDS[this.capacityIndexInPrimes];
        this.keys = new Object[this.capacity];
        this.values = new int[this.capacity];
        int i = 0;
        while (i < capacityOld) {
            Object k = keysOld[i];
            if (k != null) {
                int h = System.identityHashCode(k);
                int h2 = 8 - (h & 7);
                h %= this.capacity;
                while (this.keys[h] != null) {
                    h = (h + h2) % this.capacity;
                }
                this.keys[h] = k;
                this.values[h] = valuesOld[i];
            }
            ++i;
        }
    }

    public int size() {
        return this.nEntries;
    }

    public Object[] getObjectsArray() {
        Object[] r = new Object[this.nEntries];
        int i = 0;
        while (i < this.capacity) {
            if (this.keys[i] != null) {
                r[this.values[i]] = this.keys[i];
            }
            ++i;
        }
        return r;
    }

    public void clear() {
        this.nEntries = 0;
        Arrays.fill(this.keys, null);
        Arrays.fill(this.keysOrdered, null);
    }

    static {
        int i = 0;
        while (i < PRIMES.length) {
            ObjectIndexer.THRESHOLDS[i] = (int)((double)PRIMES[i] * 0.7);
            ++i;
        }
    }
}

