/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.misc;

import com.sap.engine.library.bytecode.misc.JobQueue;

public final class JobQueueImpl
implements JobQueue {
    private static int jobQueueThreadCounter = 0;
    private final Object lock = new Object();
    private Thread thread;
    private Runnable[] queue;
    private int pQueue;
    private int nQueue;

    public void addJob(Runnable job) {
        Object object;
        if (job == null) {
            return;
        }
        if (this.thread == null) {
            object = this.lock;
            synchronized (object) {
                this.thread = new JobQueueThread();
                this.thread.start();
                this.queue = new Runnable[128];
                this.nQueue = 0;
                this.pQueue = 0;
            }
        }
        object = this.lock;
        synchronized (object) {
            if (this.nQueue == this.queue.length) {
                Runnable[] oldQueue = this.queue;
                this.queue = new Runnable[this.nQueue * 2];
                System.arraycopy(oldQueue, this.pQueue, this.queue, 0, this.nQueue - this.pQueue);
                System.arraycopy(oldQueue, 0, this.queue, this.nQueue - this.pQueue, this.pQueue);
                this.pQueue = 0;
            }
            this.queue[(this.pQueue + this.nQueue) % this.queue.length] = job;
            ++this.nQueue;
            this.lock.notify();
        }
    }

    private Runnable pop() {
        Runnable job;
        Object object = this.lock;
        synchronized (object) {
            if (this.nQueue == 0) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.nQueue == 0) {
                throw new RuntimeException("The lock was notified but the queue is still empty");
            }
            job = this.queue[this.pQueue];
            this.queue[this.pQueue] = null;
            this.pQueue = (this.pQueue + 1) % this.queue.length;
            --this.nQueue;
        }
        return job;
    }

    public boolean isFree() {
        return this.nQueue == 0;
    }

    private class JobQueueThread
    extends Thread {
        public JobQueueThread() {
            super("JobQueue-" + jobQueueThreadCounter);
            jobQueueThreadCounter++;
        }

        public void run() {
            while (true) {
                try {
                    JobQueueImpl.this.pop().run();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

