/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.misc;

import com.sap.engine.library.bytecode.misc.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class GUIUtils {
    public static final Toolkit toolkit = Toolkit.getDefaultToolkit();
    public static final int screenWidth;
    public static final int screenHeight;
    public static final Dimension HALF_SCREEN;
    public static final Border EMPTY_BORDER_5;
    public static final Border EMPTY_BORDER_2;
    public static final Border EMPTY_BORDER_1;
    public static final FileSystemView FILE_SYSTEM_VIEW;
    public static final Insets INSETS_0_0_0_0;
    public static final Insets INSETS_2_2_2_2;
    public static final Insets INSETS_5_5_5_5;
    private static final Clipboard CLIPBOARD;
    public static final Color white;
    public static final Color lightGray;
    public static final Color gray;
    public static final Color darkGray;
    public static final Color black;
    public static final Color red;
    public static final Color pink;
    public static final Color orange;
    public static final Color yellow;
    public static final Color green;
    public static final Color magenta;
    public static final Color cyan;
    public static final Color blue;
    private static final HashSet plafSensitiveComponents;

    public static void centerWindow(Window window) {
        int width = window.getWidth();
        int height = window.getHeight();
        ((Component)window).setLocation((screenWidth - width) / 2, (screenHeight - height) / 2);
    }

    public static TreePath[] nodesToPaths(TreeNode[] nodes) {
        if (nodes == null) {
            return null;
        }
        int length = nodes.length;
        TreePath[] paths = new TreePath[length];
        int i = 0;
        while (i < length) {
            paths[i] = GUIUtils.nodeToPath(nodes[i]);
            ++i;
        }
        return paths;
    }

    public static TreeNode[] pathsToNodes(TreePath[] paths) {
        if (paths == null) {
            return null;
        }
        int length = paths.length;
        TreeNode[] nodes = new TreeNode[length];
        int i = 0;
        while (i < length) {
            nodes[i] = (TreeNode)paths[i].getLastPathComponent();
            ++i;
        }
        return nodes;
    }

    public static TreePath nodeToPath(TreeNode node) {
        TreeNode parent = node.getParent();
        if (parent == null) {
            return new TreePath(node);
        }
        return GUIUtils.nodeToPath(parent).pathByAddingChild(node);
    }

    public static void dumpSwingTree(Component c) {
        GUIUtils.dumpSwingTree(c, 0);
    }

    public static void dumpSwingTree(Component c, int indent) {
        Component[] children;
        int i = 0;
        while (i < indent) {
            System.out.print("  ");
            ++i;
        }
        System.out.println(c.getClass().getName() + " -> " + c);
        if (c instanceof Container && (children = ((Container)c).getComponents()) != null) {
            int nChildren = children.length;
            int i2 = 0;
            while (i2 < nChildren) {
                int indent1 = indent + 1;
                GUIUtils.dumpSwingTree(children[i2], indent1);
                ++i2;
            }
        }
    }

    public static JFrame showInAFrame(Component c) {
        final JFrame frame = new JFrame(StringUtils.fqNameToShortName(c.getClass().getName()));
        frame.getContentPane().add(c);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        ((Component)frame).setSize(HALF_SCREEN);
        GUIUtils.centerWindow(frame);
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("lookAndFeel")) {
                    SwingUtilities.updateComponentTreeUI(frame);
                }
            }
        });
        frame.show();
        return frame;
    }

    public static JButton createJButton(Action action) {
        JButton button = new JButton(action);
        GUIUtils.setMnemonicOnAbstractButton(button, action);
        return button;
    }

    public static JCheckBox createJCheckBox(Action action) {
        JCheckBox checkBox = new JCheckBox(action);
        GUIUtils.setMnemonicOnAbstractButton(checkBox, action);
        return checkBox;
    }

    public static JLabel createJLabel(Action action) {
        JLabel label = new JLabel((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon"), 2);
        Object mnemonic = action.getValue("MnemonicKey");
        if (mnemonic != null && mnemonic instanceof Integer) {
            label.setDisplayedMnemonic((char)((Integer)mnemonic).intValue());
        }
        return label;
    }

    public static JPanel createJLabelAndJTextFieldPair(Action action) {
        return GUIUtils.createJLabelAndJTextFieldPair(action, new JTextField(20));
    }

    public static JPanel createJLabelAndJTextFieldPair(final Action action, final JTextField textField) {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        JLabel label = new JLabel((String)action.getValue("Name"), null, 2);
        Object mnemonic = action.getValue("MnemonicKey");
        if (mnemonic != null && mnemonic instanceof Integer) {
            label.setDisplayedMnemonic((char)((Integer)mnemonic).intValue());
        }
        action.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("enabled")) {
                    textField.setEnabled(action.isEnabled());
                }
            }
        });
        textField.addActionListener(action);
        panel.add((Component)label, "West");
        panel.add((Component)textField, "Center");
        return panel;
    }

    public static JRadioButton createJRadioButton(Action action) {
        JRadioButton radioButton = new JRadioButton(action);
        GUIUtils.setMnemonicOnAbstractButton(radioButton, action);
        return radioButton;
    }

    public static JMenuItem createJMenuItem(Action action) {
        JMenuItem item = new JMenuItem(action);
        GUIUtils.setMnemonicOnAbstractButton(item, action);
        return item;
    }

    public static JMenu createJMenu(String formattedName, Action[] actions) {
        JMenu menu = new JMenu(GUIUtils.formattedNameToName(formattedName));
        char mnemonic = GUIUtils.formattedNameToMnemonic(formattedName);
        if (mnemonic != '\u0000') {
            menu.setMnemonic(mnemonic);
        }
        if (actions != null) {
            int i = 0;
            while (i < actions.length) {
                if (actions[i] != null) {
                    menu.add(GUIUtils.createJMenuItem(actions[i]));
                }
                ++i;
            }
        }
        return menu;
    }

    private static void setMnemonicOnAbstractButton(AbstractButton abstractButton, Action action) {
        Object mnemonic = action.getValue("MnemonicKey");
        if (mnemonic != null && mnemonic instanceof Integer) {
            abstractButton.setMnemonic((char)((Integer)mnemonic).intValue());
        }
    }

    public static JDialog createJDialog(final Component owner, Container contentPane, String title, boolean modal) {
        Window ownerWindow;
        final JDialog dialog = owner == null ? new JDialog((Frame)null, title, modal){

            public void show() {
                this.pack();
                this.setLocationRelativeTo(owner);
                super.show();
            }
        } : ((ownerWindow = SwingUtilities.windowForComponent(owner)) instanceof Frame ? new JDialog((Frame)ownerWindow, title, modal){

            public void show() {
                this.pack();
                this.setLocationRelativeTo(owner);
                super.show();
            }
        } : (ownerWindow instanceof Dialog ? new JDialog((Dialog)ownerWindow, title, modal){

            public void show() {
                this.pack();
                this.setLocationRelativeTo(owner);
                super.show();
            }
        } : new JDialog((Frame)null, title, modal){

            public void show() {
                this.pack();
                this.setLocationRelativeTo(owner);
                super.show();
            }
        }));
        if (contentPane != null) {
            dialog.setContentPane(contentPane);
        }
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("lookAndFeel")) {
                    SwingUtilities.updateComponentTreeUI(dialog);
                }
            }
        });
        return dialog;
    }

    public static void configureGridBag(Container container, Object[][] componentConstraintPairs) {
        GridBagLayout layout = new GridBagLayout();
        int i = 0;
        while (i < componentConstraintPairs.length) {
            Component c = (Component)componentConstraintPairs[i][0];
            GridBagConstraints constraints = (GridBagConstraints)componentConstraintPairs[i][1];
            container.add(c);
            layout.setConstraints(c, constraints);
            ++i;
        }
        container.setLayout(layout);
    }

    public static void setKeyStrokes(JComponent component, Action[] actions) {
        if (actions != null) {
            InputMap inputMap = component.getInputMap(1);
            ActionMap actionMap = component.getActionMap();
            int i = 0;
            while (i < actions.length) {
                KeyStroke keyStroke;
                if (actions[i] != null && (keyStroke = (KeyStroke)actions[i].getValue("AcceleratorKey")) != null) {
                    Object name = actions[i].getValue("Name");
                    inputMap.put(keyStroke, name);
                    actionMap.put(name, actions[i]);
                }
                ++i;
            }
        }
    }

    public static Color stringToColour(String s) {
        try {
            int x = Integer.parseInt(s.substring(1), 16);
            return new Color(x);
        }
        catch (Exception e) {
            return Color.black;
        }
    }

    public static String colourToString(Color colour) {
        return "#" + StringUtils.toHexString(colour.getRGB(), 6);
    }

    public static String formattedNameToName(String formattedName) {
        int indexOfAmpersand = formattedName.indexOf(38);
        if (indexOfAmpersand == -1 || indexOfAmpersand == formattedName.length()) {
            return formattedName;
        }
        return formattedName.substring(0, indexOfAmpersand) + formattedName.substring(indexOfAmpersand + 1);
    }

    public static char formattedNameToMnemonic(String formattedName) {
        int indexOfAmpersand = formattedName.indexOf(38);
        if (indexOfAmpersand == -1 || indexOfAmpersand == formattedName.length()) {
            return '\u0000';
        }
        char ch = formattedName.charAt(indexOfAmpersand + 1);
        if (ch == '&') {
            return '\u0000';
        }
        return ch;
    }

    public static void addPLAFSensitiveComponent(Component c) {
        plafSensitiveComponents.add(new WeakReference<Component>(c));
    }

    public static void setClipboard(String s) {
        StringSelection selection = new StringSelection(s);
        CLIPBOARD.setContents(selection, selection);
    }

    public static String getClipboard() {
        try {
            return String.valueOf(CLIPBOARD.getContents(null).getTransferData(DataFlavor.stringFlavor));
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        EMPTY_BORDER_5 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        EMPTY_BORDER_2 = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        EMPTY_BORDER_1 = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        FILE_SYSTEM_VIEW = FileSystemView.getFileSystemView();
        INSETS_0_0_0_0 = new Insets(0, 0, 0, 0);
        INSETS_2_2_2_2 = new Insets(2, 2, 2, 2);
        INSETS_5_5_5_5 = new Insets(5, 5, 5, 5);
        CLIPBOARD = toolkit.getSystemClipboard();
        white = new Color(255, 255, 255);
        lightGray = new Color(192, 192, 192);
        gray = new Color(128, 128, 128);
        darkGray = new Color(64, 64, 64);
        black = new Color(0, 0, 0);
        red = new Color(255, 0, 0);
        pink = new Color(255, 175, 175);
        orange = new Color(255, 200, 0);
        yellow = new Color(255, 255, 0);
        green = new Color(0, 255, 0);
        magenta = new Color(255, 0, 255);
        cyan = new Color(0, 255, 255);
        blue = new Color(0, 0, 255);
        plafSensitiveComponents = new HashSet();
        Dimension screenSize = toolkit.getScreenSize();
        screenWidth = screenSize.width;
        screenHeight = screenSize.height;
        HALF_SCREEN = new Dimension(screenWidth / 2, screenHeight / 2);
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                HashSet hashSet = plafSensitiveComponents;
                synchronized (hashSet) {
                    Iterator i = plafSensitiveComponents.iterator();
                    while (i.hasNext()) {
                        WeakReference reference = (WeakReference)i.next();
                        Component c = (Component)reference.get();
                        if (c == null) {
                            plafSensitiveComponents.remove(reference);
                            continue;
                        }
                        SwingUtilities.updateComponentTreeUI(c);
                    }
                }
            }
        });
    }
}

