/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.misc;

import com.sap.engine.library.bytecode.misc.IntComparator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Comparator;
import javax.swing.Action;

public final class ArrayUtils {
    public static final int[] INT_ARRAY_0 = new int[0];
    public static final Object[] OBJECT_ARRAY_0 = new Object[0];
    public static final String[] STRING_ARRAY_0 = new String[0];
    public static final Class[] CLASS_ARRAY_0 = new Class[0];
    public static final File[] FILE_ARRAY_0 = new File[0];
    public static final Class[] CLASS_ARRAY_1_STRING = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ArrayUtils.class$("java.lang.String")) : class$java$lang$String};
    static /* synthetic */ Class class$java$lang$String;

    private ArrayUtils() {
    }

    public static int[] sortByIndices(final int[] a) {
        IntComparator intComparator = new IntComparator(){

            public int compare(int i, int j) {
                return a[i] - a[j];
            }
        };
        int[] result = ArrayUtils.createOmegaArray(a.length);
        ArrayUtils.sort(result, intComparator);
        return result;
    }

    public static int[] sortByIndices(final Comparable[] a) {
        IntComparator intComparator = new IntComparator(){

            public int compare(int i, int j) {
                return a[i].compareTo(a[j]);
            }
        };
        int[] result = ArrayUtils.createOmegaArray(a.length);
        ArrayUtils.sort(result, intComparator);
        return result;
    }

    public static int[] sortByIndices(final Object[] a, final Comparator comparator) {
        IntComparator intComparator = new IntComparator(){

            public int compare(int i, int j) {
                return comparator.compare(a[i], a[j]);
            }
        };
        int[] result = ArrayUtils.createOmegaArray(a.length);
        ArrayUtils.sort(result, intComparator);
        return result;
    }

    private static int[] createOmegaArray(int n) {
        int[] r = new int[n];
        int i = 0;
        while (i < n) {
            r[i] = i;
            ++i;
        }
        return r;
    }

    public static void sort(int[] a, IntComparator comparator) {
        ArrayUtils.sort(a, 0, a.length, comparator);
    }

    /*
     * Unable to fully structure code
     */
    public static void sort(int[] a, int start, int end, IntComparator comparator) {
        block13: {
            block12: {
                if (end - start >= 8) break block12;
                i = start;
                while (i < end) {
                    k = i;
                    ak = a[k];
                    j = i + 1;
                    while (j < end) {
                        if (comparator.compare(a[j], ak) < 0) {
                            k = j;
                            ak = a[k];
                        }
                        ++j;
                    }
                    if (k != i) {
                        a[k] = a[i];
                        a[i] = ak;
                    }
                    ++i;
                }
                break block13;
            }
            axisIndex = (start + end) / 2;
            length = end - start;
            if (length > 16) {
                if (length > 32) {
                    delta = length / 9;
                    axisIndex = ArrayUtils.medianOf3(a, ArrayUtils.medianOf3(a, start, start + delta, start + delta + delta, comparator), ArrayUtils.medianOf3(a, end - 1, end - 1 - delta, end - 1 - delta - delta, comparator), ArrayUtils.medianOf3(a, axisIndex, axisIndex + delta, axisIndex - delta, comparator), comparator);
                } else {
                    axisIndex = ArrayUtils.medianOf3(a, start, end - 1, axisIndex, comparator);
                }
            }
            axisValue = a[axisIndex];
            left = start;
            right = end - 1;
            a[axisIndex] = a[left];
            isAxisLeft = true;
            block2: while (true) {
                if (!isAxisLeft) ** GOTO lbl-1000
                while (comparator.compare(axisValue, a[right]) < 0) {
                    if (left >= --right) break block2;
                }
                a[left] = a[right];
                isAxisLeft = false;
                continue;
                while (++left < right) lbl-1000:
                // 2 sources

                {
                    if (comparator.compare(a[left], axisValue) <= 0) continue;
                    a[right] = a[left];
                    isAxisLeft = true;
                    continue block2;
                }
                break;
            }
            a[left] = axisValue;
            if (left > start) {
                ArrayUtils.sort(a, start, left, comparator);
            }
            if (left + 1 < end) {
                ArrayUtils.sort(a, left + 1, end, comparator);
            }
        }
    }

    private static int medianOf3(int[] x, int a, int b, int c, IntComparator comparator) {
        boolean rac;
        boolean rbc;
        int xa = x[a];
        int xb = x[b];
        int xc = x[c];
        boolean rab = comparator.compare(xa, xb) < 0;
        boolean bl = rbc = comparator.compare(xb, xc) < 0;
        if (rab == rbc) {
            return b;
        }
        boolean bl2 = rac = comparator.compare(xa, xc) < 0;
        if (rac == rab) {
            return c;
        }
        return a;
    }

    public static int[] resize(int[] a) {
        int[] r = new int[2 * a.length];
        System.arraycopy(a, 0, r, 0, a.length);
        return r;
    }

    public static int[][] resize(int[][] a) {
        int[][] r = new int[2 * a.length][];
        System.arraycopy(a, 0, r, 0, a.length);
        return r;
    }

    public static Class[] resize(Class[] a) {
        Class[] r = new Class[2 * a.length];
        System.arraycopy(a, 0, r, 0, a.length);
        return r;
    }

    public static ClassLoader[] resize(ClassLoader[] a) {
        ClassLoader[] r = new ClassLoader[2 * a.length];
        System.arraycopy(a, 0, r, 0, a.length);
        return r;
    }

    public static String[] resize(String[] a) {
        String[] r = new String[2 * a.length];
        System.arraycopy(a, 0, r, 0, a.length);
        return r;
    }

    public static String[][] resize(String[][] a) {
        String[][] r = new String[2 * a.length][];
        System.arraycopy(a, 0, r, 0, a.length);
        return r;
    }

    public static boolean[][] resize(boolean[][] a) {
        boolean[][] r = new boolean[2 * a.length][];
        System.arraycopy(a, 0, r, 0, a.length);
        return r;
    }

    public static byte[][] resize(byte[][] a) {
        byte[][] r = new byte[2 * a.length][];
        System.arraycopy(a, 0, r, 0, a.length);
        return r;
    }

    public static Action[][] resize(Action[][] a) {
        Action[][] r = new Action[2 * a.length][];
        System.arraycopy(a, 0, r, 0, a.length);
        return r;
    }

    public static Object resize(Object[] a) {
        Object r = Array.newInstance(a.getClass().getComponentType(), 2 * a.length);
        System.arraycopy(a, 0, r, 0, a.length);
        return r;
    }

    public static URL findOnClasspath(File[] classpath, String name) {
        if (classpath == null || name == null) {
            return null;
        }
        int nClasspath = classpath.length;
        int i = 0;
        while (i < nClasspath) {
            File file = new File(classpath[i], name);
            if (file.exists()) {
                try {
                    return file.toURL();
                }
                catch (MalformedURLException mue) {
                    return null;
                }
            }
            ++i;
        }
        return null;
    }

    public static byte[] readFully(InputStream in) throws IOException {
        return ArrayUtils.readFully(in, null);
    }

    public static byte[] readFully(InputStream in, byte[] initialBuffer) throws IOException {
        int k;
        byte[] buffer = initialBuffer == null ? new byte[2048] : initialBuffer;
        int nBuffer = 0;
        while ((k = in.read(buffer, nBuffer, buffer.length - nBuffer)) != -1) {
            if (buffer.length != (nBuffer += k)) continue;
            byte[] bufferOld = buffer;
            buffer = new byte[nBuffer * 2 + 8];
            System.arraycopy(bufferOld, 0, buffer, 0, nBuffer);
        }
        byte[] r = new byte[nBuffer];
        System.arraycopy(buffer, 0, r, 0, nBuffer);
        return r;
    }

    public static String toString(Object[] objects) {
        if (objects == null) {
            return String.valueOf(null);
        }
        if (objects.length == 0) {
            return "[]";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append('[').append(objects[0]);
        int i = 1;
        while (i < objects.length) {
            buffer.append(',').append(objects[i]);
            ++i;
        }
        buffer.append(']');
        return buffer.toString();
    }

    public static String toString(int[] ints) {
        if (ints == null) {
            return String.valueOf(null);
        }
        Object[] objects = new Object[ints.length];
        int i = 0;
        while (i < ints.length) {
            objects[i] = Integer.toString(ints[i]);
            ++i;
        }
        return ArrayUtils.toString(objects);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

