/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.propertieseditor;

import com.sap.engine.library.bytecode.gui.common.AbstractInternationalizedAction;
import com.sap.engine.library.bytecode.gui.common.KeyMap;
import com.sap.engine.library.bytecode.gui.filechooser.FileChooserFieldPanel;
import com.sap.engine.library.bytecode.gui.propertieseditor.PropertiesEditor;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.ResourceManager;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

final class PropertiesEditorExportDialog
extends JDialog {
    private static final String TITLE = ResourceManager.get(120);
    private final PropertiesEditor owner;
    private JRadioButton radioButtonAllProperties;
    private JRadioButton radioButtonSelectedProperties;
    private JRadioButton radioButtonToClipboard;
    private JRadioButton radioButtonToAFile;
    private FileChooserFieldPanel fileChooserFieldPanel;
    private JCheckBox checkBoxFixCRLF;
    private final Action actionOk = new AbstractInternationalizedAction("OK", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            Properties p;
            Properties properties = p = PropertiesEditorExportDialog.this.radioButtonAllProperties.isSelected() ? PropertiesEditorExportDialog.this.owner.getProperties() : PropertiesEditorExportDialog.this.owner.getSelectedProperties();
            if (PropertiesEditorExportDialog.this.radioButtonToClipboard.isSelected()) {
                ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                try {
                    p.store(out, null);
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(PropertiesEditorExportDialog.this, ResourceManager.get(137) + "\n" + e1, ResourceManager.get(118), 0);
                    return;
                }
                String s = new String(out.toByteArray());
                if (PropertiesEditorExportDialog.this.checkBoxFixCRLF.isSelected()) {
                    s = PropertiesEditorExportDialog.fixCRLF(s);
                }
                StringSelection selection = new StringSelection(s);
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                toolkit.getSystemClipboard().setContents(selection, selection);
                JOptionPane.showMessageDialog(PropertiesEditorExportDialog.this, ResourceManager.get(128), ResourceManager.get(117), 1);
            } else {
                File file = PropertiesEditorExportDialog.this.fileChooserFieldPanel.getSelectedFile();
                if (file == null) {
                    JOptionPane.showMessageDialog(PropertiesEditorExportDialog.this, ResourceManager.get(136), ResourceManager.get(135), 0);
                    return;
                }
                try {
                    FileOutputStream out = new FileOutputStream(file);
                    p.store(out, null);
                    out.close();
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(PropertiesEditorExportDialog.this, ResourceManager.get(137) + "\n" + e1, ResourceManager.get(118), 0);
                    return;
                }
                JOptionPane.showMessageDialog(PropertiesEditorExportDialog.this, ResourceManager.get(129, file), ResourceManager.get(117), 1);
            }
            PropertiesEditorExportDialog.this.hide();
        }
    };
    private final Action actionCancel = new AbstractInternationalizedAction("CANCEL", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            PropertiesEditorExportDialog.this.hide();
        }
    };
    private final Action actionCheckBoxFixCRLF = new AbstractInternationalizedAction("FIX_CR_LF", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
        }
    };

    public PropertiesEditorExportDialog(PropertiesEditor owner, Frame frame) {
        super(frame, TITLE, true);
        this.owner = owner;
        this.init();
    }

    public PropertiesEditorExportDialog(PropertiesEditor owner, Dialog dialog) {
        super(dialog, TITLE, true);
        this.owner = owner;
        this.init();
    }

    private void init() {
        JPanel contentPane = new JPanel();
        contentPane.setBorder(GUIUtils.EMPTY_BORDER_5);
        this.radioButtonAllProperties = new JRadioButton(ResourceManager.get(112), true);
        this.radioButtonAllProperties.setSelected(true);
        this.radioButtonAllProperties.setMnemonic(ResourceManager.get(113).charAt(0));
        this.radioButtonSelectedProperties = new JRadioButton(ResourceManager.get(133));
        this.radioButtonSelectedProperties.setMnemonic(ResourceManager.get(134).charAt(0));
        this.radioButtonToClipboard = new JRadioButton(ResourceManager.get(114));
        this.radioButtonToClipboard.setMnemonic(ResourceManager.get(115).charAt(0));
        this.radioButtonToAFile = new JRadioButton(ResourceManager.get(121), true);
        this.radioButtonToAFile.setMnemonic(ResourceManager.get(122).charAt(0));
        this.fileChooserFieldPanel = new FileChooserFieldPanel();
        ButtonGroup group0 = new ButtonGroup();
        group0.add(this.radioButtonAllProperties);
        group0.add(this.radioButtonSelectedProperties);
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.radioButtonToClipboard);
        group1.add(this.radioButtonToAFile);
        JPanel panel0 = new JPanel(new GridLayout(0, 1));
        panel0.setBorder(BorderFactory.createTitledBorder(ResourceManager.get(119)));
        panel0.add(this.radioButtonAllProperties);
        panel0.add(this.radioButtonSelectedProperties);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 1));
        panel1.setBorder(BorderFactory.createTitledBorder(ResourceManager.get(116)));
        JPanel panel1Main = new JPanel(new GridLayout(0, 1));
        panel1Main.add(this.radioButtonToClipboard);
        panel1Main.add(this.radioButtonToAFile);
        JPanel panel1Indented = new JPanel(new GridLayout(0, 1));
        panel1Indented.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        panel1Indented.add(this.fileChooserFieldPanel);
        panel1.add(panel1Main);
        panel1.add(panel1Indented);
        JPanel panel2 = new JPanel(new GridLayout(0, 1));
        panel2.setBorder(BorderFactory.createTitledBorder(ResourceManager.get(127)));
        this.checkBoxFixCRLF = GUIUtils.createJCheckBox(this.actionCheckBoxFixCRLF);
        this.actionCheckBoxFixCRLF.setEnabled(false);
        this.checkBoxFixCRLF.setAlignmentX(0.0f);
        panel2.add(this.checkBoxFixCRLF);
        JPanel panel3 = new JPanel(new GridLayout(1, 0, 5, 5));
        panel3.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JButton buttonOk = GUIUtils.createJButton(this.actionOk);
        panel3.add(buttonOk);
        JButton buttonCancel = GUIUtils.createJButton(this.actionCancel);
        panel3.add(buttonCancel);
        GridBagLayout layout = new GridBagLayout();
        Insets insets = GUIUtils.INSETS_0_0_0_0;
        contentPane.add(panel0);
        layout.setConstraints(panel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        contentPane.add(panel1);
        layout.setConstraints(panel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        contentPane.add(panel2);
        layout.setConstraints(panel2, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 2, insets, 0, 0));
        contentPane.add(panel3);
        layout.setConstraints(panel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        contentPane.setLayout(layout);
        super.setContentPane(contentPane);
        super.pack();
        GUIUtils.centerWindow(this);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean isToFile = PropertiesEditorExportDialog.this.radioButtonToAFile.isSelected();
                PropertiesEditorExportDialog.this.fileChooserFieldPanel.setEnabled(isToFile);
                PropertiesEditorExportDialog.this.actionCheckBoxFixCRLF.setEnabled(!isToFile);
            }
        };
        this.radioButtonToClipboard.addActionListener(actionListener);
        this.radioButtonToAFile.addActionListener(actionListener);
        contentPane.setInputMap(1, KeyMap.INPUT_MAP);
        ActionMap actionMap = contentPane.getActionMap();
        actionMap.put("dialog-ok", this.actionOk);
        actionMap.put("dialog-cancel", this.actionCancel);
    }

    private static String fixCRLF(String s) {
        int index1;
        StringBuffer buffer = new StringBuffer(s.length());
        int index = 0;
        while ((index1 = s.indexOf(13, index)) != -1) {
            buffer.append(s.substring(index, index1));
            index = index1 + 1;
        }
        if (index < s.length()) {
            buffer.append(s.substring(index));
        }
        return buffer.toString();
    }

    public static void main(String[] args) throws Exception {
        new PropertiesEditorExportDialog(null, (Frame)null).show();
    }
}

