/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.propertieseditor;

import com.sap.engine.library.bytecode.gui.common.AbstractInternationalizedAction;
import com.sap.engine.library.bytecode.gui.common.KeyMap;
import com.sap.engine.library.bytecode.gui.propertieseditor.NameValuePairComparator;
import com.sap.engine.library.bytecode.gui.propertieseditor.PropertiesEditorExportDialog;
import com.sap.engine.library.bytecode.gui.propertieseditor.PropertiesEditorTableCellRenderer;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public final class PropertiesEditor
extends JPanel {
    private static final String[] COLUMN_NAMES = new String[]{ResourceManager.get(125), ResourceManager.get(138)};
    private static final String DEFAULT_NEW_PROPERTY_NAME = ResourceManager.get(126);
    private final DefaultTableModel model;
    private final JTable table;
    private final JTextField textFieldName;
    private final JTextField textFieldValue;
    private Properties originalProperties;
    private PropertiesEditorExportDialog exportDialog;
    private final Action actionAdd = new AbstractInternationalizedAction("ADD", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            int nRows = PropertiesEditor.this.model.getRowCount();
            Properties p = PropertiesEditor.this.getProperties();
            String name = DEFAULT_NEW_PROPERTY_NAME;
            int counter = 1;
            while (p.getProperty(name) != null) {
                name = DEFAULT_NEW_PROPERTY_NAME + " (" + ++counter + ")";
            }
            PropertiesEditor.this.model.addRow(new Object[]{name, ""});
            PropertiesEditor.this.table.changeSelection(nRows, -1, false, false);
            PropertiesEditor.this.textFieldName.selectAll();
            PropertiesEditor.this.textFieldName.requestFocus();
        }
    };
    private final Action actionRemove = new AbstractInternationalizedAction("REMOVE", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            int[] selectedRows = PropertiesEditor.this.table.getSelectedRows();
            if (selectedRows == null || selectedRows.length == 0) {
                return;
            }
            if (selectedRows.length == 1) {
                Object name = PropertiesEditor.this.model.getValueAt(selectedRows[0], 0);
                int x = JOptionPane.showConfirmDialog(PropertiesEditor.this, ResourceManager.get(131, name), ResourceManager.get(132), 0, 3);
                if (x != 0) {
                    return;
                }
                PropertiesEditor.this.model.removeRow(selectedRows[0]);
            } else {
                int x = JOptionPane.showConfirmDialog(PropertiesEditor.this, ResourceManager.get(130, selectedRows.length), ResourceManager.get(132), 0, 3);
                if (x != 0) {
                    return;
                }
                Arrays.sort(selectedRows);
                int i = selectedRows.length - 1;
                while (i >= 0) {
                    PropertiesEditor.this.model.removeRow(selectedRows[i]);
                    --i;
                }
            }
            PropertiesEditor.this.updateActionEnabling();
        }
    };
    private final Action actionExport = new AbstractInternationalizedAction("EXPORT", ResourceManager.bundle){
        static /* synthetic */ Class class$java$awt$Window;

        public void actionPerformed(ActionEvent e) {
            if (PropertiesEditor.this.exportDialog == null) {
                Container w = SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = 3.class$("java.awt.Window")) : class$java$awt$Window, PropertiesEditor.this);
                if (w instanceof Frame) {
                    PropertiesEditor.this.exportDialog = new PropertiesEditorExportDialog(PropertiesEditor.this, (Frame)w);
                } else if (w instanceof Dialog) {
                    PropertiesEditor.this.exportDialog = new PropertiesEditorExportDialog(PropertiesEditor.this, (Dialog)w);
                } else {
                    PropertiesEditor.this.exportDialog = new PropertiesEditorExportDialog(PropertiesEditor.this, (Frame)null);
                }
            }
            PropertiesEditor.this.exportDialog.show();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    };
    private final Action actionName = new AbstractInternationalizedAction("LABEL_NAME", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
        }
    };
    private final Action actionValue = new AbstractInternationalizedAction("LABEL_VALUE", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
        }
    };

    public PropertiesEditor() {
        super(new BorderLayout(5, 5));
        super.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.model = new DefaultTableModel(COLUMN_NAMES, 0){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        final PropertiesEditorTableCellRenderer renderer = new PropertiesEditorTableCellRenderer(this);
        this.table = new JTable(this.model){

            public TableCellRenderer getCellRenderer(int row, int column) {
                return renderer;
            }
        };
        this.textFieldName = new JTextField();
        this.textFieldName.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PropertiesEditor.this.textFieldName.selectAll();
            }
        });
        this.textFieldValue = new JTextField();
        this.textFieldValue.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PropertiesEditor.this.textFieldValue.selectAll();
            }
        });
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(this.actionAdd);
        toolBar.add(this.actionRemove);
        toolBar.add(this.actionExport);
        super.add((Component)toolBar, "North");
        super.add((Component)new JScrollPane(this.table), "Center");
        JPanel panelSouth = new JPanel();
        JLabel labelName = GUIUtils.createJLabel(this.actionName);
        labelName.setLabelFor(this.textFieldName);
        JLabel labelValue = GUIUtils.createJLabel(this.actionValue);
        labelValue.setLabelFor(this.textFieldValue);
        GridBagLayout panelSouthLayout = new GridBagLayout();
        Insets insets = GUIUtils.INSETS_5_5_5_5;
        panelSouth.add(labelName);
        panelSouthLayout.addLayoutComponent(labelName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        panelSouth.add(this.textFieldName);
        panelSouthLayout.addLayoutComponent(this.textFieldName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        panelSouth.add(labelValue);
        panelSouthLayout.addLayoutComponent(labelValue, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        panelSouth.add(this.textFieldValue);
        panelSouthLayout.addLayoutComponent(this.textFieldValue, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
        panelSouth.setLayout(panelSouthLayout);
        super.add((Component)panelSouth, "South");
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                PropertiesEditor.this.updateActionEnabling();
            }
        });
        this.updateActionEnabling();
        this.textFieldName.setEnabled(false);
        this.textFieldValue.setEnabled(false);
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                int[] selectedRows = PropertiesEditor.this.table.getSelectedRows();
                if (selectedRows == null || selectedRows.length != 1) {
                    return;
                }
                PropertiesEditor.this.model.setValueAt(PropertiesEditor.this.textFieldName.getText(), selectedRows[0], 0);
                PropertiesEditor.this.model.setValueAt(PropertiesEditor.this.textFieldValue.getText(), selectedRows[0], 1);
            }
        };
        this.textFieldName.addKeyListener(keyListener);
        this.textFieldValue.addKeyListener(keyListener);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    PropertiesEditor.this.textFieldValue.selectAll();
                    PropertiesEditor.this.textFieldValue.requestFocus();
                }
            }
        });
        super.setInputMap(1, KeyMap.INPUT_MAP);
        ActionMap actionMap = super.getActionMap();
        actionMap.put("delete", this.actionRemove);
        actionMap.put("new", this.actionAdd);
    }

    private void updateActionEnabling() {
        int[] selectedRows = this.table.getSelectedRows();
        int nSelectedRows = selectedRows == null ? 0 : selectedRows.length;
        this.textFieldName.setText(nSelectedRows != 1 ? "" : (String)this.model.getValueAt(selectedRows[0], 0));
        this.textFieldValue.setText(nSelectedRows != 1 ? "" : (String)this.model.getValueAt(selectedRows[0], 1));
        this.textFieldName.setEnabled(nSelectedRows == 1);
        this.textFieldValue.setEnabled(nSelectedRows == 1);
        this.actionRemove.setEnabled(nSelectedRows > 0);
    }

    public void setProperties(Properties p) {
        this.originalProperties = PropertiesEditor.cloneProperties(p);
        this.model.setNumRows(0);
        if (p == null) {
            return;
        }
        ArrayList<Object[]> nameValuePairsList = new ArrayList<Object[]>(((Hashtable)p).size());
        Enumeration<?> enumeration = p.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = p.getProperty(name);
            nameValuePairsList.add(new Object[]{name, value});
        }
        Object[][] nameValuePairs = (Object[][])nameValuePairsList.toArray((T[])new Object[nameValuePairsList.size()][]);
        Arrays.sort(nameValuePairs, NameValuePairComparator.INSTANCE);
        this.model.setDataVector(nameValuePairs, COLUMN_NAMES);
    }

    public Properties getProperties() {
        Properties r = new Properties();
        int nRows = this.table.getRowCount();
        int i = 0;
        while (i < nRows) {
            r.setProperty((String)this.table.getValueAt(i, 0), (String)this.table.getValueAt(i, 1));
            ++i;
        }
        return r;
    }

    String getOriginalProperty(String name) {
        return this.originalProperties == null ? null : this.originalProperties.getProperty(name);
    }

    int getNumberOfSelectedProperties() {
        int[] selectedRows = this.table.getSelectedRows();
        return selectedRows == null ? 0 : selectedRows.length;
    }

    Properties getSelectedProperties() {
        Properties r = new Properties();
        int[] selectedRows = this.table.getSelectedRows();
        if (selectedRows != null) {
            int i = 0;
            while (i < selectedRows.length) {
                r.setProperty((String)this.model.getValueAt(selectedRows[i], 0), (String)this.model.getValueAt(selectedRows[i], 1));
                ++i;
            }
        }
        return r;
    }

    private static Properties cloneProperties(Properties p) {
        Properties r = new Properties();
        Enumeration<?> enumeration = p.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = p.getProperty(name);
            r.setProperty(name, value);
        }
        return r;
    }

    public static void main(String[] args) throws Exception {
        PropertiesEditor p = new PropertiesEditor();
        p.setProperties(System.getProperties());
        GUIUtils.showInAFrame(p);
    }
}

