/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.modifierwizard;

import com.sap.engine.library.bytecode.gui.modifierwizard.PackageSystemView;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

final class PackageSystemViewForJar
implements PackageSystemView {
    private final String baseURL;
    private final String[] entries;

    PackageSystemViewForJar(File file) throws IOException {
        String fileToURL;
        ZipFile zipFile = new ZipFile(file);
        HashSet set = new HashSet();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            String name = enumeration.nextElement().getName();
            PackageSystemViewForJar.addWithAncestors(set, name);
        }
        this.entries = set.toArray(new String[set.size()]);
        Arrays.sort(this.entries);
        try {
            fileToURL = file.toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            fileToURL = "file://" + file;
        }
        this.baseURL = "jar:" + fileToURL + "!/";
    }

    private static void addWithAncestors(Set set, String name) {
        if (set.contains(name)) {
            return;
        }
        String parent = PackageSystemViewForJar.getParent(name);
        if (parent != null) {
            PackageSystemViewForJar.addWithAncestors(set, parent);
        }
        set.add(name);
    }

    private static String getParent(String name) {
        int lastIndexOfSlash;
        int lName = name.length();
        if (lName == 0) {
            return null;
        }
        if (name.charAt(lName - 1) == '/') {
            name = name.substring(0, lName - 1);
        }
        if ((lastIndexOfSlash = name.lastIndexOf(47)) == -1) {
            return null;
        }
        return name.substring(0, lastIndexOfSlash + 1);
    }

    public String[] list(String name) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < this.entries.length) {
            int indexOfSlash;
            String s = this.entries[i];
            if (s.startsWith(name) && ((indexOfSlash = s.indexOf(47, name.length())) == -1 || indexOfSlash == s.length() - 1) && s.length() != name.length()) {
                list.add(s);
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public InputStream openStream(String path) throws IOException {
        return new URL(new URL(this.baseURL), path).openStream();
    }
}

