/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.modifierwizard;

import com.sap.engine.library.bytecode.gui.modifierwizard.PackageSystemView;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;

final class PackageSystemViewForDir
implements PackageSystemView {
    private String baseURL;
    private final File baseDir;

    PackageSystemViewForDir(File baseDir) {
        this.baseDir = baseDir;
        try {
            this.baseURL = baseDir.toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            this.baseURL = baseDir.toString();
        }
    }

    public String[] list(String path) {
        File dir = new File(this.baseDir, path);
        String[] children = dir.list();
        if (children == null) {
            return new String[0];
        }
        int i = 0;
        while (i < children.length) {
            children[i] = new File(dir, children[i]).isDirectory() ? path + children[i] + '/' : path + children[i];
            ++i;
        }
        return children;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public InputStream openStream(String path) throws IOException {
        return new FileInputStream(new File(this.baseDir, path));
    }
}

