/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.modifierwizard;

import com.sap.engine.library.bytecode.cf.CFFactory;
import com.sap.engine.library.bytecode.cf.CFParser;
import com.sap.engine.library.bytecode.cf.ClassFile;
import com.sap.engine.library.bytecode.cf.MethodInfo;
import com.sap.engine.library.bytecode.gui.modifierwizard.PackageSystemTreeNodeComparator;
import com.sap.engine.library.bytecode.gui.modifierwizard.PackageSystemView;
import com.sap.engine.library.bytecode.misc.StringUtils;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;

final class PackageSystemTreeNode
implements TreeNode {
    private final PackageSystemTreeNode parent;
    private final PackageSystemView view;
    private final String path;
    private final String packageSystemIdentifier;
    private final String displayedName;
    private final int type;
    static final int T_ROOT = 1;
    static final int T_SUBTREE_OR_PACKAGE = 2;
    static final int T_CLASS = 3;
    static final int T_METHOD = 4;
    static final int T_OTHER = 5;
    private PackageSystemTreeNode[] children;
    private final PackageSystemTreeNode[] PACKAGE_SYSTEM_TREE_NODE_ARRAY_0 = new PackageSystemTreeNode[0];
    private String localProperties = null;

    PackageSystemTreeNode(PackageSystemView view) {
        this(view, null, "", "**", view.getBaseURL(), 1);
    }

    private PackageSystemTreeNode(PackageSystemView view, PackageSystemTreeNode parent, String path, String packageSystemIdentifier, String displayedName, int type) {
        this.view = view;
        this.parent = parent;
        this.path = path;
        this.packageSystemIdentifier = packageSystemIdentifier;
        this.displayedName = displayedName;
        this.type = type;
    }

    public String toString() {
        return this.displayedName;
    }

    private PackageSystemTreeNode[] getChildren() {
        if (this.children != null) {
            return this.children;
        }
        switch (this.type) {
            case 1: 
            case 2: {
                String[] childPaths = this.view.list(this.path);
                this.children = new PackageSystemTreeNode[childPaths.length];
                int i = 0;
                while (i < childPaths.length) {
                    String childDisplayedName;
                    String[] a = StringUtils.splitAndTrim(childPaths[i], '/');
                    int childType = childPaths[i].endsWith("/") ? 2 : (childPaths[i].endsWith(".class") ? 3 : 5);
                    String string = childDisplayedName = childType == 3 ? a[a.length - 1].substring(0, a[a.length - 1].length() - ".class".length()) : a[a.length - 1];
                    String childPackageSystemIdentifier = childType == 2 ? childPaths[i] + "**" : (childType == 3 ? childPaths[i].substring(0, childPaths[i].length() - ".class".length()) : "");
                    this.children[i] = new PackageSystemTreeNode(this.view, this, childPaths[i], childPackageSystemIdentifier, childDisplayedName, childType);
                    ++i;
                }
                Arrays.sort(this.children, PackageSystemTreeNodeComparator.INSTANCE);
                break;
            }
            case 3: {
                ClassFile cf;
                CFFactory factory = CFFactory.getThreadLocalInstance();
                CFParser parser = factory.createCFParser();
                try {
                    cf = parser.parse(this.view.openStream(this.path), null);
                }
                catch (Exception e) {
                    this.children = this.PACKAGE_SYSTEM_TREE_NODE_ARRAY_0;
                    break;
                }
                MethodInfo[] methods = cf.getMethodsArray();
                this.children = new PackageSystemTreeNode[methods.length];
                int i = 0;
                while (i < methods.length) {
                    String nameAndDescriptor = methods[i].getName() + methods[i].getDescriptor();
                    this.children[i] = new PackageSystemTreeNode(this.view, this, "", this.packageSystemIdentifier + '.' + nameAndDescriptor, methods[i].toJLSString(), 4);
                    ++i;
                }
                break;
            }
            default: {
                this.children = this.PACKAGE_SYSTEM_TREE_NODE_ARRAY_0;
            }
        }
        return this.children;
    }

    int getType() {
        return this.type;
    }

    String getPackageSystemIdentifier() {
        return this.packageSystemIdentifier;
    }

    String getLocalProperties() {
        return this.localProperties;
    }

    String getDisplayedName() {
        return this.displayedName;
    }

    void setLocalProperties(String localProperties) {
        this.localProperties = localProperties;
    }

    public TreeNode getChildAt(int childIndex) {
        return this.getChildren()[childIndex];
    }

    public int getChildCount() {
        return this.getChildren().length;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public int getIndex(TreeNode node) {
        PackageSystemTreeNode[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            if (node == children[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean getAllowsChildren() {
        return this.type != 4 && this.type != 5;
    }

    public boolean isLeaf() {
        return this.type == 4 || this.type == 5;
    }

    public Enumeration children() {
        final Object[] children = this.getChildren();
        return new Enumeration(){
            private int index = 0;

            public boolean hasMoreElements() {
                return this.index < children.length;
            }

            public Object nextElement() {
                return children[this.index++];
            }
        };
    }
}

