/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.modifierwizard;

import com.sap.engine.library.bytecode.gui.common.AbstractInternationalizedAction;
import com.sap.engine.library.bytecode.gui.common.IconLoader;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.ResourceManager;
import java.awt.Color;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

final class ModificationProgressDialog
extends JDialog {
    private final Frame frame;
    private final JLabel labelWithIcon;
    private final JLabel labelNClasses;
    private final JLabel labelNMethods;
    private final JLabel labelTime;
    private final JLabel labelSpeed;
    private final Timer timer;
    private int iconFlipCounter;
    private Runnable cancelRunnable;
    private long startTime;
    private int currentNClasses;
    private long currentTime;
    private final Action actionCancel = new AbstractInternationalizedAction("CANCEL", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            super.setEnabled(false);
            if (ModificationProgressDialog.this.cancelRunnable != null) {
                ModificationProgressDialog.this.cancelRunnable.run();
            }
        }
    };

    public ModificationProgressDialog(Frame frame) {
        super(frame, "Progress", true);
        this.frame = frame;
        GridBagLayout layout = new GridBagLayout();
        Container contentPane = super.getContentPane();
        this.labelWithIcon = new JLabel(ResourceManager.get(51) + "...", IconLoader.load("general/time.gif"), 0);
        this.labelWithIcon.setBackground(Color.white);
        this.labelWithIcon.setForeground(Color.black);
        contentPane.add(this.labelWithIcon);
        layout.setConstraints(this.labelWithIcon, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 0, GUIUtils.INSETS_5_5_5_5, 10, 10));
        JPanel innerPanel = new JPanel(new GridLayout(0, 2));
        innerPanel.setBorder(BorderFactory.createEtchedBorder());
        innerPanel.add(new JLabel(ResourceManager.get(90)));
        this.labelNClasses = new JLabel("0", 4);
        innerPanel.add(this.labelNClasses);
        innerPanel.add(new JLabel(ResourceManager.get(163)));
        this.labelNMethods = new JLabel("0", 4);
        innerPanel.add(this.labelNMethods);
        innerPanel.add(new JLabel(ResourceManager.get(173)));
        this.labelTime = new JLabel("0", 4);
        innerPanel.add(this.labelTime);
        innerPanel.add(new JLabel(ResourceManager.get(161)));
        this.labelSpeed = new JLabel("", 4);
        innerPanel.add(this.labelSpeed);
        contentPane.add(innerPanel);
        layout.setConstraints(innerPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, GUIUtils.INSETS_5_5_5_5, 5, 5));
        JButton buttonCancel = GUIUtils.createJButton(this.actionCancel);
        contentPane.add(buttonCancel);
        layout.setConstraints(buttonCancel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 0, GUIUtils.INSETS_5_5_5_5, 0, 0));
        contentPane.setLayout(layout);
        this.timer = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ModificationProgressDialog.this.iconFlipCounter++;
                ModificationProgressDialog.this.labelWithIcon.setOpaque((ModificationProgressDialog.this.iconFlipCounter & 1) == 0);
                ModificationProgressDialog.this.labelWithIcon.repaint();
                ModificationProgressDialog.this.currentTime = (System.currentTimeMillis() - ModificationProgressDialog.this.startTime) / 1000L;
                ModificationProgressDialog.this.labelTime.setText(ModificationProgressDialog.this.currentTime + " s");
                ModificationProgressDialog.this.updateSpeedLabel();
            }
        });
    }

    private void updateSpeedLabel() {
        if (this.currentTime == 0L) {
            this.labelSpeed.setText("N/A");
        } else {
            long speed = (long)this.currentNClasses / this.currentTime;
            this.labelSpeed.setText(speed + " classes/s");
        }
    }

    public void show() {
        this.startTime = System.currentTimeMillis();
        super.setLocationRelativeTo(this.frame);
        this.timer.start();
        super.show();
    }

    void stopTimer() {
        this.timer.stop();
    }

    public void hide() {
        this.timer.stop();
        super.hide();
    }

    public void setNClasses(int nClasses) {
        this.labelNClasses.setText(Integer.toString(nClasses));
        this.currentNClasses = nClasses;
        this.updateSpeedLabel();
    }

    public void setNMethods(int nMethods) {
        this.labelNMethods.setText(Integer.toString(nMethods));
    }

    public void setCancelAction(Runnable cancelRunnable) {
        this.cancelRunnable = cancelRunnable;
    }

    protected void finalize() throws Throwable {
        this.timer.stop();
    }
}

