/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.modifierwizard;

import com.sap.engine.library.bytecode.gui.common.IconLoader;
import com.sap.engine.library.bytecode.gui.common.SAPStyle;
import com.sap.engine.library.bytecode.gui.common.WizardPanel;
import com.sap.engine.library.bytecode.gui.common.XOptionsPane;
import com.sap.engine.library.bytecode.gui.filechooser.XFileChooser;
import com.sap.engine.library.bytecode.gui.modifierwizard.BCMWConfigurationPanel;
import com.sap.engine.library.bytecode.gui.modifierwizard.BCMWFinalPanel;
import com.sap.engine.library.bytecode.gui.modifierwizard.BCMWInitialPanel;
import com.sap.engine.library.bytecode.gui.modifierwizard.ModificationProgressDialog;
import com.sap.engine.library.bytecode.gui.modifierwizard.PackageSystemTreeNode;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.ResourceManager;
import com.sap.engine.library.bytecode.modifier.CFModifier;
import com.sap.engine.library.bytecode.modifier.ModificationResult;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public final class BytecodeModifierWizardPanel
extends WizardPanel {
    private BCMWInitialPanel initialPanel;
    private BCMWConfigurationPanel configurationPanel;
    private BCMWFinalPanel finalPanel;
    private Properties resultProperties = new Properties();
    private final XFileChooser chooser = new XFileChooser();
    static /* synthetic */ Class class$java$awt$Frame;

    private BytecodeModifierWizardPanel() {
        JPanel heading;
        this.initialPanel = new BCMWInitialPanel(this);
        this.configurationPanel = new BCMWConfigurationPanel(this);
        this.finalPanel = new BCMWFinalPanel(this);
        if (ResourceManager.get(162).charAt(0) != '1') {
            heading = null;
        } else {
            heading = new JPanel(new BorderLayout());
            heading.setBackground(Color.white);
            heading.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            heading.add((Component)new JLabel(IconLoader.load("sap/logo.gif")), "West");
            JLabel label = new JLabel(ResourceManager.get(143));
            label.setForeground(SAPStyle.GRAY);
            label.setFont(SAPStyle.FONT_BIG);
            label.setAlignmentX(0.5f);
            heading.add((Component)label, "Center");
        }
        super.init(new JPanel[]{this.initialPanel, this.configurationPanel, this.finalPanel}, heading);
        this.initialPanel.getFcpInput().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("selectedFile")) {
                    BytecodeModifierWizardPanel.super.updateButtonEnabling();
                }
            }
        });
    }

    protected void cardIndexChanged(int cardIndex) {
        if (cardIndex == 1) {
            ((Hashtable)this.resultProperties).clear();
            this.configurationPanel.setBase(this.initialPanel.getInputFile());
        } else if (cardIndex == 2) {
            this.finalPanel.update();
        }
    }

    protected boolean canGoToNext(int currentCardIndex) {
        if (currentCardIndex == 0) {
            return this.initialPanel.getInputFile() != null;
        }
        return super.canGoToNext(currentCardIndex);
    }

    protected void wizardFinished() {
        try {
            File outputDir = this.finalPanel.getOutputDirForGeneratedFiles();
            if (outputDir != null) {
                if (!outputDir.isDirectory()) {
                    outputDir = outputDir.getParentFile();
                }
                if (this.finalPanel.shouldGenerateBytecodeModifierProperties()) {
                    this.generateBytecodeModifierProperties(outputDir);
                }
                if (this.finalPanel.shouldGenerateBuildXML()) {
                    this.generateBuildXML(outputDir);
                }
            }
            if (this.finalPanel.shouldModify()) {
                int messageType;
                String message;
                final CFModifier modifier = new CFModifier();
                File inputFile = this.initialPanel.getInputFile();
                File outputFile = this.initialPanel.getOutputFile();
                if (outputFile == null) {
                    outputFile = inputFile;
                }
                Frame owner = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = BytecodeModifierWizardPanel.class$("java.awt.Frame")) : class$java$awt$Frame, this);
                final ModificationProgressDialog dialog = new ModificationProgressDialog(owner);
                dialog.pack();
                dialog.setLocationRelativeTo(owner);
                dialog.setDefaultCloseOperation(0);
                PropertyChangeListener listenerForNModifiedClasses = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        dialog.setNClasses((Integer)evt.getNewValue());
                    }
                };
                modifier.addPropertyChangeListener("nModifiedClasses", listenerForNModifiedClasses);
                PropertyChangeListener listenerForNModifiedMethods = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        dialog.setNMethods((Integer)evt.getNewValue());
                    }
                };
                modifier.addPropertyChangeListener("nModifiedMethods", listenerForNModifiedMethods);
                dialog.setCancelAction(new Runnable(){

                    public void run() {
                        dialog.hide();
                        modifier.cancel();
                    }
                });
                new Thread(){

                    public void run() {
                        dialog.show();
                    }
                }.start();
                long time0 = System.currentTimeMillis();
                ModificationResult result = null;
                modifier.setVerbosity(0);
                modifier.setCheck(true);
                modifier.setFailOnError(true);
                result = modifier.modify(inputFile, outputFile, this.resultProperties);
                dialog.stopTimer();
                long time1 = System.currentTimeMillis();
                modifier.removePropertyChangeListener(listenerForNModifiedClasses);
                modifier.removePropertyChangeListener(listenerForNModifiedMethods);
                dialog.setCancelAction(null);
                int nModifiedClasses = result.nModifiedClasses;
                int nModifiedMethods = result.nModifiedMethods;
                int nModifiedInAdvanceClasses = result.nModifiedInAdvanceClasses;
                if (nModifiedClasses == 0) {
                    message = ResourceManager.get(150);
                    messageType = 2;
                } else if (nModifiedInAdvanceClasses > 0) {
                    message = ResourceManager.get(149, new Object[]{new Integer(nModifiedClasses), new Integer(nModifiedMethods), new Integer((int)(time1 - time0)), new Integer(nModifiedInAdvanceClasses)});
                    messageType = 2;
                } else {
                    message = ResourceManager.get(148, new Object[]{new Integer(nModifiedClasses), new Integer(nModifiedMethods), new Integer((int)(time1 - time0))});
                    messageType = 1;
                }
                JOptionPane.showMessageDialog(this, message, ResourceManager.get(147), messageType);
                dialog.hide();
            } else {
                JOptionPane.showMessageDialog(this, ResourceManager.get(147), "", 1);
            }
        }
        catch (Exception e) {
            XOptionsPane.showStacktraceDialog(this, e);
        }
    }

    private void generateBytecodeModifierProperties(File file) throws IOException {
        FileOutputStream out = new FileOutputStream(new File(file, "bytecode-modifier.properties"));
        this.resultProperties.store(out, null);
        out.close();
    }

    File getInputFile() {
        return this.initialPanel.getInputFile();
    }

    private void generateBuildXML(File dir) throws IOException {
        PrintStream out = new PrintStream(new FileOutputStream(new File(dir, "build.xml")));
        File inputFile = this.initialPanel.getInputFile();
        File outputFile = this.initialPanel.getOutputFile();
        if (outputFile == null) {
            outputFile = inputFile;
        }
        out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.println();
        out.println("<!--");
        out.println("  Sample build.xml file generated by the bytecode modifier wizard.");
        out.println();
        out.println("  Make sure that the classpath in the definition of the \"modify\" task is correct.");
        out.println("  The \"modify\" task accepts the following attributes:");
        out.println("    \"inputFile\" and \"outputFile\" are required and must either represent two directories");
        out.println("                     or represent two jar files. It is not a problem if they are the same.");
        out.println("                     There is also a possibility to specify several input and output files");
        out.println("                     separated by ';' - in that case the number of input files must be");
        out.println("                     equal to the number of output files, and their types (dir/jar) must correspond.");
        out.println("    \"conf\" is the path to the properties file (normally named \"bytecode-modifier.properties\"),");
        out.println("                     which describes the modification.");
        out.println("    \"check\" is a boolean attribute. Forces the modifier to make sure that every method and");
        out.println("                     every classfile mentioned in bytecode-modifier.properties exists.");
        out.println("    \"failonerror\" stops the build procedure immediately if something goes wrong.");
        out.println("    \"verbosity\" defines how much information is printed on the console. Can be 0, 1, or 2.");
        out.println("-->");
        out.println("<project name=\"sample\" default=\"modify\">");
        out.println();
        out.println("  <target name=\"modify\">");
        out.println("    <taskdef name=\"modify\"");
        out.println("             classname=\"com.sap.engine.library.bytecode.modifier.ModifierTask\"");
        out.println("             classpath=\"" + System.getProperty("java.class.path") + "\"/>");
        out.println("    <modify conf=\"bytecode-modifier.properties\"");
        out.println("            inputFile=\"" + inputFile + "\"");
        out.println("            outputFile=\"" + outputFile + "\"");
        out.println("            check=\"true\" verbosity=\"2\" failonerror=\"true\"/>");
        out.println("  </target>");
        out.println("</project>");
        out.println();
        out.flush();
        out.close();
    }

    void setResultProperty(PackageSystemTreeNode node, String name, String value) {
        if (value == null) {
            ((Hashtable)this.resultProperties).remove(name);
        } else {
            this.resultProperties.setProperty(name, value);
        }
        this.configurationPanel.setResultProperty(node, name, value);
    }

    Properties getResultProperties() {
        return this.resultProperties;
    }

    XFileChooser getFileChooser() {
        return this.chooser;
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame(ResourceManager.get(143));
        BytecodeModifierWizardPanel wizard = new BytecodeModifierWizardPanel();
        frame.getContentPane().add(wizard);
        frame.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)frame).setSize(screenSize.width * 3 / 5, screenSize.height * 3 / 5);
        GUIUtils.centerWindow(frame);
        frame.show();
        frame.setDefaultCloseOperation(3);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

