/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.modifierwizard;

import com.sap.engine.library.bytecode.gui.common.AbstractInternationalizedAction;
import com.sap.engine.library.bytecode.gui.modifierwizard.BytecodeModifierWizardPanel;
import com.sap.engine.library.bytecode.gui.modifierwizard.PackageSystemTreeNode;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

final class BCMWOptionsPanel
extends JPanel {
    private final BytecodeModifierWizardPanel owner;
    private final JTextField textField;
    private final Action actionCheckBoxPropagate;
    private final JCheckBox checkBoxPropagate;
    private final Action actionCheckBoxModify;
    private final JCheckBox checkBoxModify;
    private final Action actionCheckBoxArgs;
    private final JCheckBox checkBoxArgs;
    private final Action actionCheckBoxFixSUID;
    private final JCheckBox checkBoxFixSUID;
    private PackageSystemTreeNode node = null;

    BCMWOptionsPanel(BytecodeModifierWizardPanel owner) {
        super(new BorderLayout(5, 5));
        this.owner = owner;
        super.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.actionCheckBoxPropagate = new AbstractInternationalizedAction("WIZ_CB_PROPAGATE", ResourceManager.bundle){

            public void actionPerformed(ActionEvent e) {
                BCMWOptionsPanel.this.refreshEnabling();
            }
        };
        this.actionCheckBoxModify = new AbstractInternationalizedAction("WIZ_CB_MODIFY", ResourceManager.bundle){

            public void actionPerformed(ActionEvent e) {
                BCMWOptionsPanel.this.refreshEnabling();
            }
        };
        this.actionCheckBoxArgs = new AbstractInternationalizedAction("WIZ_CB_ARGS", ResourceManager.bundle){

            public void actionPerformed(ActionEvent e) {
                BCMWOptionsPanel.this.refreshEnabling();
            }
        };
        this.actionCheckBoxFixSUID = new AbstractInternationalizedAction("WIZ_CB_FIX_SUID", ResourceManager.bundle){

            public void actionPerformed(ActionEvent e) {
                BCMWOptionsPanel.this.refreshEnabling();
            }
        };
        this.textField = new JTextField();
        this.checkBoxPropagate = GUIUtils.createJCheckBox(this.actionCheckBoxPropagate);
        this.checkBoxModify = GUIUtils.createJCheckBox(this.actionCheckBoxModify);
        this.checkBoxArgs = GUIUtils.createJCheckBox(this.actionCheckBoxArgs);
        this.checkBoxFixSUID = GUIUtils.createJCheckBox(this.actionCheckBoxFixSUID);
        this.textField.setEditable(false);
        JPanel panelNorth = new JPanel(new BorderLayout());
        panelNorth.add((Component)this.textField, "North");
        panelNorth.add((Component)this.checkBoxPropagate, "Center");
        JPanel panelNorthInner = new JPanel(new GridLayout(0, 1));
        panelNorthInner.setBorder(BorderFactory.createTitledBorder(ResourceManager.get(160)));
        panelNorthInner.add(this.checkBoxModify);
        panelNorthInner.add(this.checkBoxArgs);
        panelNorthInner.add(this.checkBoxFixSUID);
        panelNorth.add((Component)panelNorthInner, "South");
        super.add((Component)panelNorth, "North");
        this.refreshEnabling();
    }

    private void refreshEnabling() {
        if (this.node == null || this.node.getType() == 5) {
            this.actionCheckBoxPropagate.setEnabled(false);
            this.actionCheckBoxModify.setEnabled(false);
            this.actionCheckBoxArgs.setEnabled(false);
            this.actionCheckBoxFixSUID.setEnabled(false);
        } else {
            this.actionCheckBoxPropagate.setEnabled(true);
            if (this.checkBoxPropagate.isSelected()) {
                this.actionCheckBoxModify.setEnabled(false);
                this.actionCheckBoxArgs.setEnabled(false);
                this.actionCheckBoxFixSUID.setEnabled(false);
            } else {
                this.actionCheckBoxModify.setEnabled(true);
                boolean isCheckBoxModifySelected = this.checkBoxModify.isSelected();
                this.actionCheckBoxArgs.setEnabled(isCheckBoxModifySelected);
                this.actionCheckBoxFixSUID.setEnabled(isCheckBoxModifySelected);
                if (!isCheckBoxModifySelected) {
                    this.checkBoxArgs.setSelected(false);
                    this.checkBoxFixSUID.setSelected(true);
                }
            }
        }
        this.saveSettingsOnCurrentNode();
    }

    PackageSystemTreeNode getNode() {
        return this.node;
    }

    void saveSettingsOnCurrentNode() {
        if (this.node == null) {
            return;
        }
        if (this.node.getType() != 5) {
            String localProperties;
            if (this.checkBoxPropagate.isSelected()) {
                localProperties = null;
            } else {
                localProperties = "";
                boolean isCheckBoxModifySelected = this.checkBoxModify.isSelected();
                localProperties = localProperties + "modify=" + (isCheckBoxModifySelected ? 1 : 0);
                if (isCheckBoxModifySelected) {
                    localProperties = localProperties + ",args=" + (this.checkBoxArgs.isSelected() ? 1 : 0);
                    localProperties = localProperties + ",fix-suid=" + (this.checkBoxFixSUID.isSelected() ? 1 : 0);
                }
            }
            this.node.setLocalProperties(localProperties);
            this.owner.setResultProperty(this.node, this.node.getPackageSystemIdentifier(), localProperties);
        }
    }

    void setNode(PackageSystemTreeNode node) {
        String s;
        this.node = node;
        if (node == null) {
            s = "";
        } else {
            switch (node.getType()) {
                case 3: {
                    s = "Class ";
                    break;
                }
                case 4: {
                    s = "Method ";
                    break;
                }
                case 2: {
                    s = "Package ";
                    break;
                }
                case 1: {
                    s = "Root ";
                    break;
                }
                default: {
                    s = "";
                }
            }
            s = s + node;
        }
        this.textField.setText(s);
        if (node != null && node.getType() != 5) {
            String localProperties = node.getLocalProperties();
            this.checkBoxPropagate.setSelected(localProperties == null);
            PackageSystemTreeNode effectiveNode = node;
            String effectiveLocalProperties = null;
            while (effectiveNode != null) {
                if (effectiveNode.getLocalProperties() != null) {
                    effectiveLocalProperties = effectiveNode.getLocalProperties();
                    break;
                }
                effectiveNode = (PackageSystemTreeNode)effectiveNode.getParent();
            }
            if (effectiveLocalProperties == null) {
                this.checkBoxModify.setSelected(false);
                this.checkBoxArgs.setSelected(false);
            } else {
                this.checkBoxModify.setSelected(effectiveLocalProperties.indexOf("modify=1") != -1);
                this.checkBoxArgs.setSelected(effectiveLocalProperties.indexOf("args=1") != -1);
            }
        } else {
            this.checkBoxPropagate.setSelected(false);
            this.checkBoxModify.setSelected(false);
            this.checkBoxArgs.setSelected(false);
        }
        this.refreshEnabling();
    }
}

