/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.modifierwizard;

import com.sap.engine.library.bytecode.gui.common.AbstractInternationalizedAction;
import com.sap.engine.library.bytecode.gui.filechooser.FileChooserFieldPanel;
import com.sap.engine.library.bytecode.gui.modifierwizard.BytecodeModifierWizardPanel;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.ResourceManager;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

final class BCMWFinalPanel
extends JPanel {
    private final BytecodeModifierWizardPanel owner;
    private final Action actionCheckBoxModify;
    private final JCheckBox checkBoxModify;
    private final Action actionCheckBoxGenerateBytecodeModifierProperties;
    private final JCheckBox checkBoxGenerateBytecodeModifierProperties;
    private final Action actionCheckBoxGenerateBuildXML;
    private final JCheckBox checkBoxGenerateBuildXML;
    private final FileChooserFieldPanel chooserFieldPanelForGeneratedFiles;

    BCMWFinalPanel(BytecodeModifierWizardPanel owner) {
        this.owner = owner;
        this.actionCheckBoxModify = new AbstractInternationalizedAction("WIZ_CB_MODIFY", ResourceManager.bundle){

            public void actionPerformed(ActionEvent e) {
                BCMWFinalPanel.this.updateChooserPanelEnabling();
            }
        };
        this.actionCheckBoxGenerateBytecodeModifierProperties = new AbstractInternationalizedAction("WIZ_CB_GENERATE_PROPERTIES", ResourceManager.bundle){

            public void actionPerformed(ActionEvent e) {
                BCMWFinalPanel.this.updateChooserPanelEnabling();
            }
        };
        this.actionCheckBoxGenerateBuildXML = new AbstractInternationalizedAction("WIZ_CB_GENERATE_BUILD_XML", ResourceManager.bundle){

            public void actionPerformed(ActionEvent e) {
                BCMWFinalPanel.this.updateChooserPanelEnabling();
            }
        };
        this.checkBoxModify = GUIUtils.createJCheckBox(this.actionCheckBoxModify);
        this.checkBoxModify.setSelected(true);
        this.checkBoxGenerateBytecodeModifierProperties = GUIUtils.createJCheckBox(this.actionCheckBoxGenerateBytecodeModifierProperties);
        this.checkBoxGenerateBuildXML = GUIUtils.createJCheckBox(this.actionCheckBoxGenerateBuildXML);
        this.chooserFieldPanelForGeneratedFiles = new FileChooserFieldPanel();
        this.chooserFieldPanelForGeneratedFiles.setBorder(BorderFactory.createTitledBorder(ResourceManager.get(145)));
        Insets insets = GUIUtils.INSETS_0_0_0_0;
        Object[][] componentsAndConstraints = new Object[][]{{this.checkBoxModify, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0)}, {this.checkBoxGenerateBytecodeModifierProperties, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0)}, {this.checkBoxGenerateBuildXML, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0)}, {this.chooserFieldPanelForGeneratedFiles, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 2, insets, 0, 0)}};
        GUIUtils.configureGridBag(this, componentsAndConstraints);
        this.updateChooserPanelEnabling();
    }

    private void updateChooserPanelEnabling() {
        this.chooserFieldPanelForGeneratedFiles.setEnabled(this.checkBoxGenerateBytecodeModifierProperties.isSelected() || this.checkBoxGenerateBuildXML.isSelected());
    }

    boolean shouldGenerateBytecodeModifierProperties() {
        return this.checkBoxGenerateBytecodeModifierProperties.isSelected();
    }

    boolean shouldGenerateBuildXML() {
        return this.checkBoxGenerateBuildXML.isSelected();
    }

    boolean shouldModify() {
        return this.checkBoxModify.isSelected();
    }

    File getOutputDirForGeneratedFiles() {
        return this.chooserFieldPanelForGeneratedFiles.getSelectedFile();
    }

    void update() {
        File inputFile = this.owner.getInputFile();
        File dir = inputFile;
        if (dir != null && !dir.isDirectory()) {
            dir = dir.getParentFile();
        }
        this.chooserFieldPanelForGeneratedFiles.setSelectedFile(dir);
    }
}

