/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.modifierwizard;

import com.sap.engine.library.bytecode.gui.common.SmartTreeExpansionListener;
import com.sap.engine.library.bytecode.gui.common.XOptionsPane;
import com.sap.engine.library.bytecode.gui.modifierwizard.BCMWOptionsPanel;
import com.sap.engine.library.bytecode.gui.modifierwizard.BCMWResultPropertiesPanel;
import com.sap.engine.library.bytecode.gui.modifierwizard.BytecodeModifierWizardPanel;
import com.sap.engine.library.bytecode.gui.modifierwizard.PackageSystemCellRenderer;
import com.sap.engine.library.bytecode.gui.modifierwizard.PackageSystemTreeNode;
import com.sap.engine.library.bytecode.gui.modifierwizard.PackageSystemView;
import com.sap.engine.library.bytecode.gui.modifierwizard.PackageSystemViewForDir;
import com.sap.engine.library.bytecode.gui.modifierwizard.PackageSystemViewForJar;
import java.awt.BorderLayout;
import java.io.File;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

final class BCMWConfigurationPanel
extends JPanel {
    private final BytecodeModifierWizardPanel owner;
    private final JTree tree;
    private final BCMWOptionsPanel optionsPanel;
    private final BCMWResultPropertiesPanel resultPropertiesPanel;
    private PackageSystemTreeNode root;
    private DefaultTreeModel model;

    BCMWConfigurationPanel(BytecodeModifierWizardPanel owner) {
        super(new BorderLayout());
        this.owner = owner;
        this.tree = new JTree();
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.optionsPanel = new BCMWOptionsPanel(owner);
        this.resultPropertiesPanel = new BCMWResultPropertiesPanel(owner);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new PackageSystemCellRenderer());
        JSplitPane splitPaneRight = new JSplitPane(0, this.optionsPanel, this.resultPropertiesPanel);
        splitPaneRight.setResizeWeight(1.0);
        JSplitPane splitPane = new JSplitPane(1, new JScrollPane(this.tree), splitPaneRight);
        splitPane.setResizeWeight(1.0);
        super.add(splitPane);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                Object selected;
                TreePath selectionPath = BCMWConfigurationPanel.this.tree.getSelectionPath();
                PackageSystemTreeNode packageSystemTreeNode = selectionPath == null ? null : ((selected = selectionPath.getLastPathComponent()) instanceof PackageSystemTreeNode ? (PackageSystemTreeNode)selected : null);
                BCMWConfigurationPanel.this.optionsPanel.setNode(packageSystemTreeNode);
            }
        });
        this.tree.addTreeExpansionListener(new SmartTreeExpansionListener(this.tree));
    }

    void setBase(File file) {
        if (file != null) {
            try {
                PackageSystemView view = file.isDirectory() ? new PackageSystemViewForDir(file) : new PackageSystemViewForJar(file);
                this.root = new PackageSystemTreeNode(view);
                this.model = new DefaultTreeModel(this.root);
            }
            catch (IOException e) {
                XOptionsPane.showStacktraceDialog(this, e);
                this.model = new DefaultTreeModel(new DefaultMutableTreeNode());
            }
            this.tree.setModel(this.model);
        }
    }

    PackageSystemTreeNode getRoot() {
        return this.root;
    }

    void setResultProperty(PackageSystemTreeNode node, String name, String value) {
        this.model.nodeChanged(node);
        this.resultPropertiesPanel.setResultProperty(name, value);
    }
}

