/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.hex;

import com.sap.engine.library.bytecode.gui.hex.HexPanel;
import com.sap.engine.library.bytecode.misc.StringUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

final class HexTableModel
implements TableModel {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String[] HEX_STRINGS = new String[256];
    private static final String[] CHAR_STRINGS = new String[256];
    private final HexPanel owner;
    private final ArrayList listeners = new ArrayList();
    private final Object listenersLock = new Object();
    private byte[] data;
    private int nHexColumns;
    private int nColumns;
    private int nRows;
    static /* synthetic */ Class class$java$lang$String;

    HexTableModel(HexPanel owner) {
        this.owner = owner;
        this.data = owner.getDataWithoutCopying();
        this.nHexColumns = owner.getNHexColumns();
        this.nColumns = 2 * this.nHexColumns + 1;
        this.nRows = (this.data.length + this.nHexColumns - 1) / this.nHexColumns;
        owner.addPropertyChangeListener("data", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                HexTableModel.access$002(HexTableModel.this, HexTableModel.this.owner.getDataWithoutCopying());
                HexTableModel.this.nRows = (HexTableModel.this.data.length + HexTableModel.this.nHexColumns - 1) / HexTableModel.this.nHexColumns;
                HexTableModel.this.fireTableDataChanged();
            }
        });
    }

    public int getRowCount() {
        return this.nRows;
    }

    public int getColumnCount() {
        return this.nColumns;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Offset";
        }
        if (columnIndex <= this.nHexColumns) {
            return new String(new char[]{HEX_DIGITS[columnIndex - 1 & 0xF]});
        }
        return "";
    }

    public Class getColumnClass(int columnIndex) {
        return class$java$lang$String == null ? (class$java$lang$String = HexTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return "0x" + StringUtils.toHexString(rowIndex * this.nHexColumns, 4) + "+";
        }
        if (columnIndex <= this.nHexColumns) {
            int index = rowIndex * this.nHexColumns + (columnIndex - 1);
            return index < this.data.length ? HEX_STRINGS[this.data[index] & 0xFF] : "";
        }
        int index = rowIndex * this.nHexColumns + (columnIndex - this.nHexColumns - 1);
        return index < this.data.length ? CHAR_STRINGS[this.data[index] & 0xFF] : "";
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void addTableModelListener(TableModelListener l) {
        if (l != null) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.add(l);
            }
        }
    }

    public void removeTableModelListener(TableModelListener l) {
        if (l != null) {
            Object object = this.listenersLock;
            synchronized (object) {
                ((AbstractCollection)this.listeners).remove(l);
            }
        }
    }

    private void fireTableDataChanged() {
        Object object = this.listenersLock;
        synchronized (object) {
            int nListeners = this.listeners.size();
            if (nListeners > 0) {
                TableModelEvent event = new TableModelEvent(this);
                int i = nListeners - 1;
                while (i >= 0) {
                    ((TableModelListener)this.listeners.get(i)).tableChanged(event);
                    --i;
                }
            }
        }
    }

    static /* synthetic */ byte[] access$002(HexTableModel x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        char[] buffer = new char[2];
        int i = 0;
        while (i < 256) {
            buffer[0] = HEX_DIGITS[i >>> 4];
            buffer[1] = HEX_DIGITS[i & 0xF];
            HexTableModel.HEX_STRINGS[i] = new String(buffer, 0, 2);
            buffer[0] = (char)i;
            HexTableModel.CHAR_STRINGS[i] = new String(buffer, 0, 1);
            ++i;
        }
    }
}

