/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.hex;

import com.sap.engine.library.bytecode.gui.hex.HexPanel;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

final class HexTableCellRenderer
extends DefaultTableCellRenderer {
    private final HexPanel owner;
    private int selectionStart;
    private int selectionEnd;
    private final int nHexColumns;

    HexTableCellRenderer(HexPanel owner) {
        this.owner = owner;
        this.nHexColumns = owner.getNHexColumns();
        this.selectionStart = owner.getSelectionStart();
        this.selectionEnd = owner.getSelectionEnd();
        owner.addPropertyChangeListener("selectionInterval", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                HexTableCellRenderer.this.selectionStart = HexTableCellRenderer.this.owner.getSelectionStart();
                HexTableCellRenderer.this.selectionEnd = HexTableCellRenderer.this.owner.getSelectionEnd();
            }
        });
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int index = column == 0 ? -1 : (column <= this.nHexColumns ? row * this.nHexColumns + (column - 1) : row * this.nHexColumns + (column - this.nHexColumns - 1));
        boolean bl = isSelected = this.selectionStart <= index && index < this.selectionEnd;
        if (hasFocus && this.owner.getFocusedIndex() != index) {
            this.owner.fireFocusChanged(index);
        }
        hasFocus = index != -1 && index == this.owner.getFocusedIndex();
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

