/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.hex;

import com.sap.engine.library.bytecode.gui.hex.HexTableCellRenderer;
import com.sap.engine.library.bytecode.gui.hex.HexTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public final class HexPanel
extends JPanel {
    private final TableModel model;
    private final JTable table;
    private int nHexColumns = 8;
    public static final String DATA_PROPERTY = "data";
    private byte[] data = new byte[0];
    public static final String SELECTION_INTERVAL_PROPERTY = "selectionInterval";
    private int selectionStart = -1;
    private int selectionEnd = -1;
    public static final String FOCUSED_INDEX_PROPERTY = "focusedIndex";
    private int focusedIndex = -1;

    public HexPanel() {
        super(new BorderLayout());
        this.model = new HexTableModel(this);
        this.table = new JTable(this.model);
        TableColumnModel columnModel = this.table.getColumnModel();
        HexTableCellRenderer renderer = new HexTableCellRenderer(this);
        TableColumn column0 = columnModel.getColumn(0);
        column0.setMinWidth(55);
        column0.setPreferredWidth(55);
        column0.setCellRenderer(renderer);
        int i = 0;
        while (i < this.nHexColumns) {
            TableColumn column1 = columnModel.getColumn(i + 1);
            TableColumn column2 = columnModel.getColumn(this.nHexColumns + i + 1);
            column1.setCellRenderer(renderer);
            column2.setCellRenderer(renderer);
            column2.setPreferredWidth(10);
            ++i;
        }
        super.add((Component)new JScrollPane(this.table), "Center");
        Dimension size = new Dimension(400, 200);
        super.setPreferredSize(size);
        super.setMinimumSize(size);
    }

    public byte[] getData() {
        return (byte[])this.getDataWithoutCopying().clone();
    }

    public void setData(byte[] data) {
        this.setDataWithoutCopying((byte[])data.clone());
    }

    byte[] getDataWithoutCopying() {
        return this.data;
    }

    void setDataWithoutCopying(byte[] data) {
        byte[] oldData = this.data;
        this.data = data;
        this.firePropertyChange(DATA_PROPERTY, oldData, data);
    }

    int getNHexColumns() {
        return this.nHexColumns;
    }

    public void setSelectionInterval(int start, int end) {
        this.selectionStart = start;
        this.selectionEnd = end;
        this.firePropertyChange(SELECTION_INTERVAL_PROPERTY, 0, 1);
        this.table.repaint();
        Rectangle startRectangle = this.table.getCellRect(start / this.nHexColumns, 0, true);
        Rectangle endRectangle = this.table.getCellRect((end + this.nHexColumns - 1) / this.nHexColumns, 0, true);
        this.table.scrollRectToVisible(new Rectangle(0, startRectangle.y, 1, endRectangle.y - startRectangle.y));
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public int getFocusedIndex() {
        return this.focusedIndex;
    }

    void fireFocusChanged(int newFocusedIndex) {
        int oldFocusedIndex = this.focusedIndex;
        this.focusedIndex = newFocusedIndex;
        if (oldFocusedIndex != newFocusedIndex) {
            super.firePropertyChange(FOCUSED_INDEX_PROPERTY, oldFocusedIndex, newFocusedIndex);
            this.repaint();
        }
    }

    public void addTableKeyListener(KeyListener listener) {
        this.table.addKeyListener(listener);
    }

    public void removeTableKeyListener(KeyListener listener) {
        this.table.removeKeyListener(listener);
    }

    public void addTableMouseListener(MouseListener listener) {
        this.table.addMouseListener(listener);
    }

    public void removeTableMouseListener(MouseListener listener) {
        this.table.removeMouseListener(listener);
    }
}

