/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.filechooser;

import com.sap.engine.library.bytecode.gui.common.AbstractInternationalizedAction;
import com.sap.engine.library.bytecode.gui.common.KeyMap;
import com.sap.engine.library.bytecode.gui.common.SmartTreeExpansionListener;
import com.sap.engine.library.bytecode.gui.common.TreeSearcher;
import com.sap.engine.library.bytecode.gui.common.XOptionsPane;
import com.sap.engine.library.bytecode.gui.filechooser.FileChooserCellRenderer;
import com.sap.engine.library.bytecode.gui.filechooser.FileChooserDialog;
import com.sap.engine.library.bytecode.gui.filechooser.FileNode;
import com.sap.engine.library.bytecode.gui.filechooser.FilePropertiesPanel;
import com.sap.engine.library.bytecode.gui.filechooser.FileSystemTreeModel;
import com.sap.engine.library.bytecode.gui.filechooser.FileViewImpl;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.tree.TreePath;

public final class XFileChooser
extends JPanel {
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    public static final int SINGLE_SELECTION = 1;
    public static final int CONTIGUOUS_SELECTION = 2;
    public static final int DISCONTIGUOUS_SELECTION = 4;
    private FileSystemView fileSystemView;
    private FileView fileView;
    private final JToolBar toolBar;
    private final FileNode rootNode;
    private final FileSystemTreeModel model;
    private final JTree tree;
    private FileFilter fileFilter;
    private FileChooserDialog dialog = null;
    private final Action actionRefresh = new AbstractInternationalizedAction("REFRESH", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            XFileChooser.this.rootNode.refresh();
        }
    };
    private final Action actionProperties = new AbstractInternationalizedAction("PROPERTIES", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            File file = XFileChooser.this.getSelectedFile();
            if (file != null) {
                GUIUtils.createJDialog(XFileChooser.this, new FilePropertiesPanel(file), ResourceManager.get(103), true).show();
            }
        }
    };
    private final Action actionNewFile = new AbstractInternationalizedAction("NEW_FILE", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            boolean b;
            File[] selectedFiles = XFileChooser.this.getSelectedFiles();
            if (selectedFiles.length != 1 || !selectedFiles[0].isDirectory()) {
                return;
            }
            String s = JOptionPane.showInputDialog(XFileChooser.this, ResourceManager.get(102) + ":", ResourceManager.get(99), 3);
            if (s == null) {
                return;
            }
            if ((s = s.trim()).length() == 0) {
                return;
            }
            File newFile = XFileChooser.this.fileSystemView.createFileObject(selectedFiles[0], s);
            String explanation = null;
            try {
                b = newFile.createNewFile();
            }
            catch (Exception e1) {
                explanation = e1.toString();
                b = false;
            }
            if (!b) {
                JOptionPane.showMessageDialog(XFileChooser.this, (explanation == null ? "" : explanation + "\n") + ResourceManager.get(95, (Object)s, selectedFiles[0]), ResourceManager.get(101), 0);
                return;
            }
            XFileChooser.this.rootNode.refresh();
            XFileChooser.this.setSelectedFile(newFile);
        }
    };
    private final Action actionNewDir = new AbstractInternationalizedAction("NEW_DIR", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            boolean b;
            File[] selectedFiles = XFileChooser.this.getSelectedFiles();
            if (selectedFiles.length != 1 || !selectedFiles[0].isDirectory()) {
                return;
            }
            String s = JOptionPane.showInputDialog(XFileChooser.this, ResourceManager.get(100) + ":", ResourceManager.get(98), 3);
            if (s == null) {
                return;
            }
            if ((s = s.trim()).length() == 0) {
                return;
            }
            File newDir = XFileChooser.this.fileSystemView.createFileObject(selectedFiles[0], s);
            String explanation = null;
            try {
                b = newDir.mkdir();
            }
            catch (Exception e1) {
                explanation = e1.toString();
                b = false;
            }
            if (!b) {
                JOptionPane.showMessageDialog(XFileChooser.this, (explanation == null ? "" : explanation + "\n") + ResourceManager.get(94, (Object)s, selectedFiles[0]), ResourceManager.get(101), 0);
                return;
            }
            XFileChooser.this.rootNode.refresh();
            XFileChooser.this.setSelectedFile(newDir);
            XFileChooser.this.tree.expandPath(XFileChooser.this.tree.getSelectionPath());
        }
    };
    private final Action actionNew = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            boolean newDirIsEnabled = XFileChooser.this.actionNewDir.isEnabled();
            boolean newFileIsEnabled = XFileChooser.this.actionNewFile.isEnabled();
            if (newDirIsEnabled && newFileIsEnabled) {
                int x = XOptionsPane.showListDialog(XFileChooser.this, "New", new Object[]{"Directory", "File"});
                if (x == 0) {
                    XFileChooser.this.actionNewDir.actionPerformed(e);
                } else if (x == 1) {
                    XFileChooser.this.actionNewFile.actionPerformed(e);
                }
            } else if (newDirIsEnabled) {
                XFileChooser.this.actionNewDir.actionPerformed(e);
            } else if (newFileIsEnabled) {
                XFileChooser.this.actionNewFile.actionPerformed(e);
            }
        }
    };
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$java$awt$Dialog;

    public XFileChooser() {
        this((FileSystemView)null);
    }

    public XFileChooser(FileSystemView fileSystemView) {
        super(new BorderLayout());
        this.fileSystemView = fileSystemView == null ? FileSystemView.getFileSystemView() : fileSystemView;
        this.fileView = new FileViewImpl();
        this.rootNode = new FileNode(this, null, null);
        this.model = new FileSystemTreeModel(this.rootNode);
        this.tree = new JTree(this.model);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new FileChooserCellRenderer(this));
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        JScrollPane scrollPane = new JScrollPane(this.tree);
        super.add((Component)scrollPane, "Center");
        this.toolBar = new JToolBar(0);
        this.toolBar.add(this.actionNewDir);
        this.toolBar.add(this.actionNewFile);
        this.toolBar.add(this.actionRefresh);
        this.toolBar.add(this.actionProperties);
        this.toolBar.setFloatable(false);
        super.add((Component)this.toolBar, "North");
        this.rootNode.refresh();
        this.updateButtonEnabling();
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                XFileChooser.this.updateButtonEnabling();
            }
        });
        final JPopupMenu menu = new JPopupMenu();
        menu.add(this.actionNewDir);
        menu.add(this.actionNewFile);
        menu.add(this.actionProperties);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int x = e.getX();
                    int y = e.getY();
                    int row = XFileChooser.this.tree.getRowForLocation(x, y);
                    XFileChooser.this.tree.setSelectionRow(row);
                    menu.show(XFileChooser.this.tree, x, y);
                }
            }
        });
        ActionMap actionMap0 = super.getActionMap();
        ActionMap actionMap1 = this.tree.getActionMap();
        actionMap0.put("properties", this.actionProperties);
        actionMap1.put("properties", this.actionProperties);
        actionMap0.put("refresh", this.actionRefresh);
        actionMap1.put("refresh", this.actionRefresh);
        actionMap0.put("new", this.actionNew);
        actionMap1.put("new", this.actionNew);
        super.setInputMap(1, KeyMap.INPUT_MAP);
        this.tree.setInputMap(1, KeyMap.INPUT_MAP);
        new TreeSearcher().installOn(this.tree, this.toolBar, null);
        this.setSelectedFile(new File("/"));
        this.tree.addTreeExpansionListener(new SmartTreeExpansionListener(this.tree));
    }

    public XFileChooser(File currentDirectory) {
        this(currentDirectory, null);
    }

    public XFileChooser(File currentDirectory, FileSystemView fileSystemView) {
        this(fileSystemView);
        this.setSelectedFile(currentDirectory);
    }

    public XFileChooser(String currentDirectory) {
        this(currentDirectory, null);
    }

    public XFileChooser(String currentDirectory, FileSystemView fileSystemView) {
        this(fileSystemView);
        this.setSelectedFile(new File(currentDirectory));
    }

    private void updateButtonEnabling() {
        File[] selectedFiles = this.getSelectedFiles();
        this.actionProperties.setEnabled(selectedFiles.length == 1);
        boolean canCreate = selectedFiles.length == 1 && selectedFiles[0].isDirectory() && selectedFiles[0].canWrite();
        this.actionNewFile.setEnabled(canCreate);
        this.actionNewDir.setEnabled(canCreate);
    }

    public FileSystemView getFileSystemView() {
        return this.fileSystemView;
    }

    public void setFileSystemView(FileSystemView fileSystemView) {
        this.fileSystemView = fileSystemView = fileSystemView == null ? FileSystemView.getFileSystemView() : fileSystemView;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    public FileView getFileView() {
        return this.fileView;
    }

    public void setFileView(FileView fileView) {
        this.fileView = fileView;
    }

    FileSystemTreeModel getModel() {
        return this.model;
    }

    JTree getTree() {
        return this.tree;
    }

    public void setSelectedFile(File file) {
        this.tree.clearSelection();
        if (file != null) {
            this.addSelectedFile(file);
        }
    }

    public void setCurrentDirectory(File file) {
        this.setSelectedFile(file);
    }

    public void setSelectedFiles(File[] files) {
        this.tree.clearSelection();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i] != null) {
                    this.addSelectedFile(files[i]);
                }
                ++i;
            }
        }
    }

    private boolean addSelectedFile(File file) {
        file = file.getAbsoluteFile();
        ArrayList<File> list = new ArrayList<File>();
        File x = file;
        while (x != null) {
            list.add(x);
            x = x.getParentFile();
        }
        File[] files = list.toArray(new File[list.size()]);
        Object[] nodes = new FileNode[files.length + 1];
        nodes[0] = this.rootNode;
        int i = 0;
        while (i < files.length) {
            nodes[i + 1] = ((FileNode)nodes[i]).getChildFileNodeRepresenting(files[files.length - i - 1]);
            if (nodes[i + 1] == null) {
                return false;
            }
            ++i;
        }
        TreePath treePath = new TreePath(nodes);
        this.tree.addSelectionPath(treePath);
        this.tree.scrollPathToVisible(treePath);
        return true;
    }

    public int showOpenDialog(Component parent) {
        return this.showDialog(parent, ResourceManager.get(169));
    }

    public int showSaveDialog(Component parent) {
        return this.showDialog(parent, ResourceManager.get(171));
    }

    public int showDialog(Component parent, String approveButtonText) {
        char approveButtonMnemonic;
        this.rootNode.refresh();
        if (approveButtonText == null) {
            approveButtonText = ResourceManager.get(169);
            approveButtonMnemonic = ResourceManager.get(170).charAt(0);
        } else {
            char c = approveButtonMnemonic = approveButtonText.length() > 0 ? approveButtonText.charAt(0) : (char)'\u0000';
        }
        if (this.dialog == null) {
            if (parent == null) {
                this.dialog = new FileChooserDialog(this, (Frame)null, approveButtonText, approveButtonMnemonic);
            } else {
                Frame f = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = XFileChooser.class$("java.awt.Frame")) : class$java$awt$Frame, parent);
                if (f != null) {
                    this.dialog = new FileChooserDialog(this, f, approveButtonText, approveButtonMnemonic);
                } else {
                    Dialog d = (Dialog)SwingUtilities.getAncestorOfClass(class$java$awt$Dialog == null ? (class$java$awt$Dialog = XFileChooser.class$("java.awt.Dialog")) : class$java$awt$Dialog, parent);
                    this.dialog = d != null ? new FileChooserDialog(this, d, approveButtonText, approveButtonMnemonic) : new FileChooserDialog(this, (Frame)null, approveButtonText, approveButtonMnemonic);
                }
            }
            this.dialog.addWindowListener(new WindowAdapter(){

                public void windowActivated(WindowEvent e) {
                    XFileChooser.this.rootNode.refresh();
                }
            });
        }
        if (this.getSelectedFiles().length == 0) {
            this.setSelectedFile(new File("/"));
        }
        this.tree.grabFocus();
        this.dialog.show();
        return this.dialog.getResult();
    }

    public File getSelectedFile() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        return ((FileNode)path.getLastPathComponent()).getFile();
    }

    public File[] getSelectedFiles() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths == null) {
            return new File[0];
        }
        File[] r = new File[paths.length];
        int i = 0;
        while (i < paths.length) {
            r[i] = ((FileNode)paths[i].getLastPathComponent()).getFile();
            ++i;
        }
        return r;
    }

    public void setSelectionMode(int mode) {
        if (mode != 1 && mode != 2 && mode != 4) {
            throw new IllegalArgumentException();
        }
        this.tree.getSelectionModel().setSelectionMode(mode);
    }

    public int getSelectionMode() {
        return this.tree.getSelectionModel().getSelectionMode();
    }

    public static void main(String[] args) throws Exception {
        XFileChooser chooser = new XFileChooser();
        chooser.showOpenDialog(null);
        System.out.println("chooser.getSelectedFile() = " + chooser.getSelectedFile());
        File[] files = chooser.getSelectedFiles();
        System.out.println("chooser.getSelectedFiles().length = " + files.length);
        int i = 0;
        while (i < files.length) {
            System.out.println("chooser.getSelectedFiles()[" + i + "] = " + files[i]);
            ++i;
        }
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

