/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.filechooser;

import com.sap.engine.library.bytecode.gui.common.AbstractInternationalizedAction;
import com.sap.engine.library.bytecode.gui.filechooser.XFileChooser;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class PathsEditorPanel
extends JPanel {
    private XFileChooser chooser = new XFileChooser();
    private DefaultListModel model = new DefaultListModel();
    private JList list = new JList(this.model);
    private final Action actionAdd = new AbstractInternationalizedAction("ADD", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            int x = PathsEditorPanel.this.chooser.showDialog(PathsEditorPanel.this, ResourceManager.get(92));
            if (x != 0) {
                return;
            }
            File[] files = PathsEditorPanel.this.chooser.getSelectedFiles();
            if (files == null) {
                return;
            }
            int i = 0;
            while (i < files.length) {
                File f = files[i];
                PathsEditorPanel.this.addPathEntry(f);
                ++i;
            }
            PathsEditorPanel.this.list.setSelectedIndex(PathsEditorPanel.this.model.getSize() - 1);
        }
    };
    private Action actionRemove = new AbstractInternationalizedAction("REMOVE", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            int[] indices = PathsEditorPanel.this.list.getSelectedIndices();
            if (indices == null) {
                return;
            }
            int nIndices = indices.length;
            int i = 0;
            while (i < nIndices) {
                PathsEditorPanel.this.model.removeElementAt(indices[i]);
                ++i;
            }
            if (PathsEditorPanel.this.model.getSize() != 0) {
                if (indices.length == 1) {
                    if (indices[0] != 0) {
                        PathsEditorPanel.this.list.setSelectedIndex(indices[0] - 1);
                    } else {
                        PathsEditorPanel.this.list.setSelectedIndex(0);
                    }
                } else {
                    PathsEditorPanel.this.list.setSelectedIndex(PathsEditorPanel.this.model.getSize() - 1);
                }
            } else {
                PathsEditorPanel.this.list.clearSelection();
            }
        }
    };
    private Action actionMoveUp = new AbstractInternationalizedAction("MOVE_UP", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            int index = PathsEditorPanel.this.list.getSelectedIndex();
            if (index < 1) {
                return;
            }
            try {
                Object x = PathsEditorPanel.this.model.elementAt(index);
                PathsEditorPanel.this.model.removeElementAt(index);
                PathsEditorPanel.this.model.add(index - 1, x);
            }
            catch (Exception exception) {
                // empty catch block
            }
            PathsEditorPanel.this.list.setSelectedIndex(index - 1);
        }
    };
    private Action actionMoveDown = new AbstractInternationalizedAction("MOVE_DOWN", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            int index = PathsEditorPanel.this.list.getSelectedIndex();
            if (index < 0 || index >= PathsEditorPanel.this.model.size()) {
                return;
            }
            try {
                Object x = PathsEditorPanel.this.model.elementAt(index);
                PathsEditorPanel.this.model.removeElementAt(index);
                PathsEditorPanel.this.model.add(index + 1, x);
            }
            catch (Exception exception) {
                // empty catch block
            }
            PathsEditorPanel.this.list.setSelectedIndex(index + 1);
        }
    };

    public PathsEditorPanel() {
        super(new BorderLayout(5, 5));
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(this.actionAdd);
        toolBar.add(this.actionRemove);
        toolBar.add(this.actionMoveUp);
        toolBar.add(this.actionMoveDown);
        super.add((Component)toolBar, "North");
        this.actionAdd.setEnabled(true);
        this.actionRemove.setEnabled(false);
        this.actionMoveUp.setEnabled(false);
        this.actionMoveDown.setEnabled(false);
        this.list.setSelectionMode(2);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int[] indices = PathsEditorPanel.this.list.getSelectedIndices();
                if (indices == null || indices.length == 0) {
                    PathsEditorPanel.this.actionRemove.setEnabled(false);
                    PathsEditorPanel.this.actionMoveUp.setEnabled(false);
                    PathsEditorPanel.this.actionMoveDown.setEnabled(false);
                } else if (indices.length == 1) {
                    PathsEditorPanel.this.actionRemove.setEnabled(true);
                    PathsEditorPanel.this.actionMoveUp.setEnabled(indices[0] > 0);
                    PathsEditorPanel.this.actionMoveDown.setEnabled(indices[0] < PathsEditorPanel.this.model.size() - 1);
                } else {
                    PathsEditorPanel.this.actionRemove.setEnabled(true);
                    PathsEditorPanel.this.actionMoveUp.setEnabled(false);
                    PathsEditorPanel.this.actionMoveDown.setEnabled(false);
                }
            }
        });
        super.add((Component)new JScrollPane(this.list), "Center");
    }

    public File[] getEntries() {
        Object[] a = this.model.toArray();
        File[] r = new File[a.length];
        int i = 0;
        while (i < r.length) {
            r[i] = (File)a[i];
            ++i;
        }
        return r;
    }

    void setEntries(File[] entries, int nEntries) {
        this.model.removeAllElements();
        int i = 0;
        while (i < nEntries) {
            this.model.addElement(entries[i]);
            ++i;
        }
    }

    public void addListDataListener(ListDataListener listener) {
        this.model.addListDataListener(listener);
    }

    public void removeListDataListener(ListDataListener listener) {
        this.model.removeListDataListener(listener);
    }

    public void addPathEntry(File f) {
        if (f != null && !this.model.contains(f)) {
            this.model.addElement(f);
        }
    }

    public static void main(String[] args) throws Exception {
        GUIUtils.showInAFrame(new PathsEditorPanel());
    }
}

