/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.filechooser;

import com.sap.engine.library.bytecode.gui.filechooser.FileNode;
import java.util.Arrays;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

final class FileSystemTreeModel
implements TreeModel {
    private final FileNode root;
    private TreeModelListener[] listeners;
    private int nListeners;
    private Object listenersLock = new Object();

    FileSystemTreeModel(FileNode root) {
        this.root = root;
        this.listeners = new TreeModelListener[8];
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object parent, int index) {
        return ((FileNode)parent).getChildAt(index);
    }

    public int getChildCount(Object parent) {
        return ((FileNode)parent).getChildCount();
    }

    public boolean isLeaf(Object node) {
        return ((FileNode)node).isLeaf();
    }

    public int getIndexOfChild(Object parent, Object child) {
        return ((FileNode)parent).getIndex((FileNode)child);
    }

    public void addTreeModelListener(TreeModelListener l) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.nListeners >= this.listeners.length) {
                TreeModelListener[] oldListeners = this.listeners;
                this.listeners = new TreeModelListener[this.nListeners * 2];
                System.arraycopy(oldListeners, 0, this.listeners, 0, this.nListeners);
            }
            this.listeners[this.nListeners++] = l;
        }
    }

    public void removeTreeModelListener(TreeModelListener l) {
        Object object = this.listenersLock;
        synchronized (object) {
            int i = 0;
            while (i < this.nListeners) {
                if (this.listeners[i] == l) {
                    this.listeners[i] = this.listeners[--this.nListeners];
                    this.listeners[this.nListeners] = null;
                    break;
                }
                ++i;
            }
        }
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    void fireTreeNodesRemoved(Object[] path, int[] childIndices, Object[] childObjects) {
        if (this.nListeners > 0) {
            Arrays.sort(childIndices);
            TreeModelEvent event = new TreeModelEvent((Object)this, path, childIndices, childObjects);
            Object object = this.listenersLock;
            synchronized (object) {
                int i = 0;
                while (i < this.nListeners) {
                    this.listeners[i].treeNodesRemoved(event);
                    ++i;
                }
            }
        }
    }

    void fireTreeNodesInserted(Object[] path, int[] childIndices, Object[] childObjects) {
        if (this.nListeners > 0) {
            Arrays.sort(childIndices);
            TreeModelEvent event = new TreeModelEvent((Object)this, path, childIndices, childObjects);
            Object object = this.listenersLock;
            synchronized (object) {
                int i = 0;
                while (i < this.nListeners) {
                    this.listeners[i].treeNodesInserted(event);
                    ++i;
                }
            }
        }
    }
}

