/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.filechooser;

import com.sap.engine.library.bytecode.gui.common.AbstractInternationalizedAction;
import com.sap.engine.library.bytecode.gui.common.KeyMap;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Date;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public final class FilePropertiesPanel
extends JPanel {
    private final JTextField tfName = new JTextField(20);
    private final JCheckBox cbCanRead = GUIUtils.createJCheckBox(new AbstractInternationalizedAction("CAN_READ", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
        }
    });
    private final JCheckBox cbCanWrite = GUIUtils.createJCheckBox(new AbstractInternationalizedAction("CAN_WRITE", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
        }
    });
    private final JCheckBox cbHidden = GUIUtils.createJCheckBox(new AbstractInternationalizedAction("IS_HIDDEN", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
        }
    });
    private final JLabel labelLastModified = new JLabel();
    private final JLabel labelFileSize = new JLabel();
    private final Action actionOk = new AbstractInternationalizedAction("OK", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            SwingUtilities.windowForComponent(FilePropertiesPanel.this).hide();
        }
    };
    private static final int TOLERANCE = 100;

    FilePropertiesPanel(File file) {
        super(new BorderLayout());
        JPanel panelSouth = new JPanel(new FlowLayout(2));
        JButton buttonOk = GUIUtils.createJButton(this.actionOk);
        panelSouth.add(buttonOk);
        super.add((Component)panelSouth, "South");
        JPanel panelCentre = new JPanel();
        this.tfName.setEditable(false);
        this.cbHidden.setEnabled(false);
        this.cbCanRead.setEnabled(false);
        this.cbCanWrite.setEnabled(false);
        panelCentre.setLayout(new BoxLayout(panelCentre, 1));
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.anchor = 17;
        layout.setConstraints(this.tfName, c);
        panel.setBorder(BorderFactory.createTitledBorder(ResourceManager.get(107)));
        panel.add(this.tfName);
        panelCentre.add(panel);
        panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(ResourceManager.get(110)));
        panel.setLayout(new GridLayout(3, 1));
        panel.add(this.cbCanRead);
        panel.add(this.cbCanWrite);
        panel.add(this.cbHidden);
        panelCentre.add(panel);
        panel = new JPanel(new FlowLayout(0));
        panel.setBorder(BorderFactory.createTitledBorder(ResourceManager.get(106)));
        panel.add(this.labelLastModified);
        panelCentre.add(panel);
        panel = new JPanel(new FlowLayout(0));
        panel.setBorder(BorderFactory.createTitledBorder(ResourceManager.get(104)));
        panel.add(this.labelFileSize);
        panelCentre.add(panel);
        super.add((Component)panelCentre, "Center");
        this.setData(file);
        super.setInputMap(1, KeyMap.INPUT_MAP);
        ActionMap actionMap = super.getActionMap();
        actionMap.put("dialog-ok", this.actionOk);
        actionMap.put("dialog-cancel", this.actionOk);
        actionMap.put("edit", this.actionOk);
    }

    private static String fileSizeToString(long size) {
        if (size == 0L) {
            return "0";
        }
        if (size < 924L) {
            return size + " " + ResourceManager.get(93);
        }
        if (size < 946176L) {
            return (size + 512L) / 1024L + "k (" + size + " " + ResourceManager.get(93) + ")";
        }
        return ((size + 512L) / 1024L + 512L) / 1024L + "M (" + size + " " + ResourceManager.get(93) + ")";
    }

    private void setData(File file) {
        if (file == null) {
            this.tfName.setText("");
            this.cbCanRead.setSelected(false);
            this.cbCanWrite.setSelected(false);
            this.labelLastModified.setText("");
            this.labelFileSize.setText("");
            return;
        }
        this.tfName.setText(file.getAbsolutePath());
        this.tfName.selectAll();
        try {
            this.cbHidden.setSelected(file.isHidden());
        }
        catch (SecurityException e) {
            this.cbHidden.setSelected(false);
        }
        try {
            this.cbCanRead.setSelected(file.canRead());
        }
        catch (SecurityException se) {
            this.cbCanRead.setSelected(false);
        }
        try {
            this.cbCanWrite.setSelected(file.canWrite());
        }
        catch (SecurityException se) {
            this.cbCanWrite.setSelected(false);
        }
        try {
            long lastModified = file.lastModified();
            if (lastModified == 0L) {
                this.labelLastModified.setText(ResourceManager.get(109));
            } else {
                this.labelLastModified.setText(new Date(lastModified).toString());
            }
        }
        catch (SecurityException se) {
            this.labelLastModified.setText(ResourceManager.get(91));
        }
        try {
            this.labelFileSize.setText(FilePropertiesPanel.fileSizeToString(file.length()));
        }
        catch (SecurityException se) {
            this.labelFileSize.setText(ResourceManager.get(91));
        }
    }

    public static void main(String[] args) throws Exception {
        GUIUtils.createJDialog(null, new FilePropertiesPanel(new File("D:/")), "title", true).show();
    }
}

