/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.filechooser;

import com.sap.engine.library.bytecode.gui.filechooser.FileComparator;
import com.sap.engine.library.bytecode.gui.filechooser.FileNodeEnumeration;
import com.sap.engine.library.bytecode.gui.filechooser.XFileChooser;
import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;

final class FileNode
implements TreeNode {
    private static final File[] FILE_ARRAY_0 = new File[0];
    private static final FileNode[] FILE_NODE_ARRAY_0 = new FileNode[0];
    private final int type;
    static final int T_ROOT = 1;
    static final int T_DRIVE = 2;
    static final int T_DIRECTORY = 3;
    static final int T_FILE = 4;
    private final XFileChooser owner;
    private final File file;
    private final String filename;
    private final String displayed;
    private Object[] pathToRoot;
    private final FileNode parent;
    private FileNode[] childNodes;
    private final int level;

    FileNode(XFileChooser owner, File file, FileNode parent) {
        this.owner = owner;
        this.parent = parent;
        int n = this.level = parent == null ? 1 : parent.level + 1;
        if (file == null) {
            this.type = 1;
            this.filename = "";
            this.displayed = "";
        } else if (file.getParent() == null || file.getName() == null || file.getName().length() == 0) {
            this.type = 2;
            this.filename = file.getName();
            this.displayed = file.toString();
        } else if (file.isDirectory()) {
            this.type = 3;
            this.filename = file.getName();
            String d = this.filename;
            if (d != null && d.startsWith("ShellFolder:")) {
                d = file.toString();
            }
            this.displayed = d;
        } else {
            this.type = 4;
            this.displayed = this.filename = file.getName();
        }
        this.file = file;
    }

    int getType() {
        return this.type;
    }

    File getFile() {
        return this.file;
    }

    String getFilename() {
        return this.filename;
    }

    public String toString() {
        return this.displayed;
    }

    private File[] getChildFiles() {
        File[] childFiles;
        switch (this.type) {
            case 1: {
                childFiles = this.owner.getFileSystemView().getRoots();
                break;
            }
            case 2: 
            case 3: {
                childFiles = this.owner.getFileSystemView().getFiles(this.file, false);
                break;
            }
            default: {
                return FILE_ARRAY_0;
            }
        }
        Arrays.sort(childFiles, FileComparator.INSTANCE);
        return childFiles;
    }

    private FileNode[] getChildNodes() {
        if (this.childNodes != null) {
            return this.childNodes;
        }
        File[] childFiles = this.getChildFiles();
        if (childFiles.length == 0) {
            this.childNodes = FILE_NODE_ARRAY_0;
            return FILE_NODE_ARRAY_0;
        }
        this.childNodes = new FileNode[childFiles.length];
        int i = 0;
        while (i < childFiles.length) {
            this.childNodes[i] = new FileNode(this.owner, childFiles[i], this);
            ++i;
        }
        return this.childNodes;
    }

    /*
     * Unable to fully structure code
     */
    void refresh() {
        block12: {
            if (this.childNodes == null) {
                return;
            }
            oldChildFiles = new File[this.childNodes.length];
            i = 0;
            while (i < this.childNodes.length) {
                oldChildFiles[i] = this.childNodes[i].file;
                ++i;
            }
            newChildFiles = this.getChildFiles();
            indexInOld = 0;
            indexInNew = 0;
            removedIndices = new int[oldChildFiles.length];
            nRemovedIndices = 0;
            insertedIndices = new int[newChildFiles.length];
            nInsertedIndices = 0;
            newChildNodes = new FileNode[newChildFiles.length];
            while (indexInOld < oldChildFiles.length && indexInNew < newChildFiles.length) {
                pathOld = oldChildFiles[indexInOld].getPath();
                c = pathOld.compareTo(pathNew = newChildFiles[indexInNew].getPath());
                if (c == 0) {
                    newChildFiles[indexInNew] = oldChildFiles[indexInOld];
                    newChildNodes[indexInNew] = this.childNodes[indexInOld];
                    ++indexInOld;
                    ++indexInNew;
                    continue;
                }
                if (c < 0) {
                    removedIndices[nRemovedIndices++] = indexInOld++;
                    continue;
                }
                insertedIndices[nInsertedIndices++] = indexInNew;
                newChildNodes[indexInNew] = new FileNode(this.owner, newChildFiles[indexInNew], this);
                ++indexInNew;
            }
            break block12;
lbl34:
            // 1 sources

            while (true) {
                removedIndices[nRemovedIndices++] = indexInOld++;
                break;
            }
        }
        ** while (indexInOld < oldChildFiles.length)
lbl38:
        // 2 sources

        while (indexInNew < newChildFiles.length) {
            insertedIndices[nInsertedIndices++] = indexInNew;
            newChildNodes[indexInNew] = new FileNode(this.owner, newChildFiles[indexInNew], this);
            ++indexInNew;
        }
        model = this.owner.getModel();
        if (nRemovedIndices > 0) {
            removedIndices = FileNode.trim(removedIndices, nRemovedIndices);
            removedObjects = new Object[nRemovedIndices];
            i = 0;
            while (i < nRemovedIndices) {
                removedObjects[i] = this.childNodes[removedIndices[i]];
                ++i;
            }
            model.fireTreeNodesRemoved(this.getPathToRoot(), removedIndices, removedObjects);
        }
        this.childNodes = newChildNodes;
        if (nInsertedIndices > 0) {
            insertedIndices = FileNode.trim(insertedIndices, nInsertedIndices);
            insertedObjects = new Object[nInsertedIndices];
            i = 0;
            while (i < nInsertedIndices) {
                insertedObjects[i] = newChildNodes[insertedIndices[i]];
                ++i;
            }
            model.fireTreeNodesInserted(this.getPathToRoot(), insertedIndices, insertedObjects);
        }
        i = 0;
        while (i < newChildNodes.length) {
            newChildNodes[i].refresh();
            ++i;
        }
    }

    private static int[] trim(int[] a, int n) {
        if (a.length == n) {
            return a;
        }
        int[] aOld = a;
        a = new int[n];
        System.arraycopy(aOld, 0, a, 0, n);
        return a;
    }

    private Object[] getPathToRoot() {
        if (this.pathToRoot == null) {
            this.pathToRoot = new Object[this.level];
            int index = this.level - 1;
            FileNode i = this;
            while (i != null) {
                this.pathToRoot[index--] = i;
                i = i.parent;
            }
        }
        return this.pathToRoot;
    }

    FileNode getChildFileNodeRepresenting(File x) {
        FileNode[] children = this.getChildNodes();
        int i = 0;
        while (i < children.length) {
            if (children[i].getFile().equals(x)) {
                return children[i];
            }
            ++i;
        }
        return null;
    }

    public TreeNode getChildAt(int childIndex) {
        return this.getChildNodes()[childIndex];
    }

    public int getChildCount() {
        return this.getChildNodes().length;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public int getIndex(TreeNode node) {
        FileNode[] children = this.getChildNodes();
        int i = 0;
        while (i < children.length) {
            if (children[i] == node) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean getAllowsChildren() {
        return this.getChildNodes().length > 0;
    }

    public boolean isLeaf() {
        return this.type == 4 || this.childNodes != null && this.childNodes.length == 0;
    }

    public Enumeration children() {
        return new FileNodeEnumeration(this.getChildNodes());
    }
}

