/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.filechooser;

import com.sap.engine.library.bytecode.gui.common.AbstractInternationalizedAction;
import com.sap.engine.library.bytecode.gui.filechooser.XFileChooser;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;

public final class FileChooserFieldPanel
extends JPanel {
    public static final String SELECTED_FILE_PROPERTY = "selectedFile";
    private static final String S_NONE = ResourceManager.get(108);
    private final XFileChooser chooser;
    private final JTextField textField;
    private final JButton button;
    private File selectedFile = null;
    private final Action actionBrowse = new AbstractInternationalizedAction("BROWSE", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            FileChooserFieldPanel.this.chooser.setSelectedFile(FileChooserFieldPanel.this.selectedFile);
            int r = FileChooserFieldPanel.this.chooser.showOpenDialog(FileChooserFieldPanel.this);
            if (r != 0) {
                return;
            }
            FileChooserFieldPanel.this.setSelectedFile(FileChooserFieldPanel.this.chooser.getSelectedFile());
        }
    };

    public FileChooserFieldPanel() {
        this(new XFileChooser());
    }

    public FileChooserFieldPanel(XFileChooser chooser) {
        super(new BorderLayout(5, 5));
        this.chooser = chooser;
        this.textField = new JTextField(S_NONE);
        this.textField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                FileChooserFieldPanel.this.textField.selectAll();
            }
        });
        this.button = GUIUtils.createJButton(this.actionBrowse);
        this.textField.setEditable(false);
        super.add((Component)this.textField, "Center");
        super.add((Component)this.button, "East");
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public void setSelectedFile(File file) {
        File oldSelectedFile = this.selectedFile;
        this.selectedFile = file;
        this.textField.setText(this.selectedFile == null ? S_NONE : this.selectedFile.toString());
        if (oldSelectedFile != null || this.selectedFile != null) {
            super.firePropertyChange(SELECTED_FILE_PROPERTY, oldSelectedFile, this.selectedFile);
        }
        this.chooser.setSelectedFile(file);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textField.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    public static void main(String[] args) throws Exception {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        FileChooserFieldPanel chooserFieldPanel = new FileChooserFieldPanel();
        panel.add((Component)chooserFieldPanel, "North");
        panel.add((Component)new JTree(), "Center");
        GUIUtils.showInAFrame(panel);
        chooserFieldPanel.addPropertyChangeListener(SELECTED_FILE_PROPERTY, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                System.out.println(evt.getPropertyName() + ": " + evt.getOldValue() + " -> " + evt.getNewValue());
            }
        });
    }
}

