/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.filechooser;

import com.sap.engine.library.bytecode.gui.common.AbstractInternationalizedAction;
import com.sap.engine.library.bytecode.gui.common.KeyMap;
import com.sap.engine.library.bytecode.gui.filechooser.FileNode;
import com.sap.engine.library.bytecode.gui.filechooser.XFileChooser;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreePath;

final class FileChooserDialog
extends JDialog {
    private final XFileChooser chooser;
    private final String approveButtonText;
    private char approveMnemonic = '\u0000';
    private Action actionApprove;
    private Action actionCancel;
    private int result = -1;

    FileChooserDialog(XFileChooser chooser, Frame owner, String approveButtonText, char approveButtonMnemonic) {
        super(owner, approveButtonText, true);
        this.chooser = chooser;
        this.approveButtonText = approveButtonText;
        this.approveMnemonic = approveButtonMnemonic;
        this.init();
    }

    FileChooserDialog(XFileChooser chooser, Dialog owner, String approveButtonText, char approveButtonMnemonic) {
        super(owner, approveButtonText, true);
        this.chooser = chooser;
        this.approveButtonText = approveButtonText;
        this.approveMnemonic = approveButtonMnemonic;
        this.init();
    }

    private void init() {
        super.setSize(new Dimension(GUIUtils.screenWidth / 3, GUIUtils.screenHeight / 2));
        GUIUtils.centerWindow(this);
        this.actionApprove = new AbstractAction(this.approveButtonText){

            public void actionPerformed(ActionEvent e) {
                FileChooserDialog.this.result = 0;
                FileChooserDialog.this.hide();
            }
        };
        this.actionCancel = new AbstractInternationalizedAction("CANCEL", ResourceManager.bundle){

            public void actionPerformed(ActionEvent e) {
                FileChooserDialog.this.result = 1;
                FileChooserDialog.this.hide();
            }
        };
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        super.setContentPane(contentPane);
        contentPane.add((Component)this.chooser, "Center");
        JPanel panelSouth = new JPanel(new FlowLayout(2));
        JPanel panelSouthInner = new JPanel(new GridLayout(1, 0, 5, 0));
        JButton buttonApprove = new JButton(this.actionApprove);
        if (this.approveMnemonic != '\u0000') {
            buttonApprove.setMnemonic(this.approveMnemonic);
        }
        panelSouthInner.add(buttonApprove);
        JButton buttonCancel = GUIUtils.createJButton(this.actionCancel);
        char cancelMnemonic = ResourceManager.get(0).charAt(0);
        buttonCancel.setMnemonic(cancelMnemonic);
        panelSouthInner.add(buttonCancel);
        panelSouth.add(panelSouthInner);
        contentPane.add((Component)panelSouth, "South");
        super.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FileChooserDialog.this.result = 1;
            }
        });
        contentPane.setInputMap(1, KeyMap.INPUT_MAP);
        ActionMap actionMap = contentPane.getActionMap();
        actionMap.put("dialog-ok", this.actionApprove);
        actionMap.put("dialog-cancel", this.actionCancel);
        this.chooser.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                FileChooserDialog.this.updateButtonEnabling();
            }
        });
        this.updateButtonEnabling();
    }

    private void updateButtonEnabling() {
        JTree tree = this.chooser.getTree();
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null) {
            this.actionApprove.setEnabled(true);
            return;
        }
        FileFilter fileFilter = this.chooser.getFileFilter();
        if (fileFilter == null) {
            this.actionApprove.setEnabled(true);
            return;
        }
        boolean shouldEnableApproveAction = true;
        int i = 0;
        while (i < paths.length) {
            FileNode node;
            File file;
            Object lastPathComponent = paths[i].getLastPathComponent();
            if (lastPathComponent instanceof FileNode && !fileFilter.accept(file = (node = (FileNode)lastPathComponent).getFile())) {
                shouldEnableApproveAction = false;
                break;
            }
            ++i;
        }
        this.actionApprove.setEnabled(shouldEnableApproveAction);
    }

    int getResult() {
        return this.result;
    }
}

