/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.filechooser;

import com.sap.engine.library.bytecode.gui.common.IconLoader;
import com.sap.engine.library.bytecode.gui.filechooser.FileNode;
import com.sap.engine.library.bytecode.gui.filechooser.XFileChooser;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

final class FileChooserCellRenderer
extends DefaultTreeCellRenderer {
    private static final ImageIcon ICON_FILE_DEFAULT = IconLoader.load("files/filedefault.gif");
    private static final ImageIcon ICON_DIR_CLOSED = IconLoader.load("files/dirclosed.gif");
    private static final ImageIcon ICON_DIR_OPEN = IconLoader.load("files/diropen.gif");
    private static final ImageIcon ICON_DRIVE = IconLoader.load("files/drive.gif");
    private final XFileChooser owner;

    FileChooserCellRenderer(XFileChooser owner) {
        this.owner = owner;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        FileNode node = (FileNode)value;
        int t = node.getType();
        switch (t) {
            case 1: {
                break;
            }
            case 2: {
                super.setIcon(ICON_DRIVE);
                break;
            }
            case 3: {
                super.setIcon(expanded ? ICON_DIR_OPEN : ICON_DIR_CLOSED);
                break;
            }
            default: {
                Icon icon = this.owner.getFileView().getIcon(node.getFile());
                super.setIcon(icon == null ? ICON_FILE_DEFAULT : icon);
                break;
            }
        }
        return this;
    }
}

