/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.filechooser;

import com.sap.engine.library.bytecode.gui.common.AbstractInternationalizedAction;
import com.sap.engine.library.bytecode.gui.filechooser.XFileChooser;
import com.sap.engine.library.bytecode.misc.ArrayUtils;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class ClasspathPanel
extends JPanel {
    private final JList list;
    private final DefaultListModel model;
    private XFileChooser chooser = null;
    private final Action actionAdd = new AbstractInternationalizedAction("ADD", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            int index;
            if (ClasspathPanel.this.chooser == null) {
                ClasspathPanel.this.chooser = new XFileChooser();
            }
            File file = (index = ClasspathPanel.this.list.getSelectedIndex()) == -1 ? null : new File((String)ClasspathPanel.this.model.getElementAt(index));
            ClasspathPanel.this.chooser.setSelectedFile(file);
            int x = ClasspathPanel.this.chooser.showOpenDialog(ClasspathPanel.this);
            if (x != 0) {
                return;
            }
            ClasspathPanel.this.list.clearSelection();
            Object[] oldFilenames = ClasspathPanel.this.model.toArray();
            File[] addedFiles = ClasspathPanel.this.chooser.getSelectedFiles();
            String[] addedFilenames = new String[addedFiles.length];
            int i = 0;
            while (i < addedFiles.length) {
                addedFilenames[i] = addedFiles[i].getAbsolutePath();
                boolean mustAdd = true;
                int j = 0;
                while (j < oldFilenames.length) {
                    if (addedFilenames[i].equals(oldFilenames[j])) {
                        ClasspathPanel.this.list.addSelectionInterval(j, j);
                        mustAdd = false;
                        break;
                    }
                    ++j;
                }
                if (mustAdd) {
                    ClasspathPanel.this.model.addElement(addedFilenames[i]);
                    int y = ClasspathPanel.this.model.size() - 1;
                    ClasspathPanel.this.list.addSelectionInterval(y, y);
                }
                ++i;
            }
            ClasspathPanel.this.updateActionEnabling();
        }
    };
    private final Action actionRemove = new AbstractInternationalizedAction("REMOVE", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            int[] indices = ClasspathPanel.this.list.getSelectedIndices();
            if (indices.length == 0) {
                return;
            }
            int i = indices.length - 1;
            while (i >= 0) {
                ClasspathPanel.this.model.removeElementAt(indices[i]);
                --i;
            }
            int nElements = ClasspathPanel.this.model.size();
            if (nElements == 0) {
                ClasspathPanel.this.list.setSelectedIndices(new int[0]);
            } else if (indices[0] < nElements) {
                ClasspathPanel.this.list.setSelectedIndex(indices[0]);
            } else {
                ClasspathPanel.this.list.setSelectedIndex(nElements - 1);
            }
            ClasspathPanel.this.updateActionEnabling();
        }
    };
    private final Action actionMoveUp = new AbstractInternationalizedAction("MOVE_UP", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            int index = ClasspathPanel.this.list.getSelectedIndex();
            if (index < 1) {
                return;
            }
            Object h = ClasspathPanel.this.model.getElementAt(index);
            ClasspathPanel.this.model.setElementAt(ClasspathPanel.this.model.getElementAt(index - 1), index);
            ClasspathPanel.this.model.setElementAt(h, index - 1);
            ClasspathPanel.this.list.setSelectedIndex(index - 1);
        }
    };
    private final Action actionMoveDown = new AbstractInternationalizedAction("MOVE_DOWN", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            int index = ClasspathPanel.this.list.getSelectedIndex();
            if (index == -1 || index == ClasspathPanel.this.model.size() - 1) {
                return;
            }
            Object h = ClasspathPanel.this.model.getElementAt(index);
            ClasspathPanel.this.model.setElementAt(ClasspathPanel.this.model.getElementAt(index + 1), index);
            ClasspathPanel.this.model.setElementAt(h, index + 1);
            ClasspathPanel.this.list.setSelectedIndex(index + 1);
        }
    };

    public ClasspathPanel() {
        super(new BorderLayout());
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ClasspathPanel.this.updateActionEnabling();
            }
        });
        super.add((Component)new JScrollPane(this.list), "Center");
        JToolBar toolBar = new JToolBar();
        toolBar.add(this.actionAdd);
        toolBar.add(this.actionRemove);
        toolBar.add(this.actionMoveUp);
        toolBar.add(this.actionMoveDown);
        toolBar.setFloatable(false);
        super.add((Component)toolBar, "North");
        this.actionAdd.putValue("AcceleratorKey", KeyStroke.getKeyStroke("INSERT"));
        GUIUtils.setKeyStrokes(this, new Action[]{this.actionAdd, this.actionRemove, this.actionMoveUp, this.actionMoveDown});
    }

    private void updateActionEnabling() {
        int[] indices = this.list.getSelectedIndices();
        this.actionMoveUp.setEnabled(indices.length == 1 && indices[0] > 0);
        this.actionMoveDown.setEnabled(indices.length == 1 && indices[0] < this.model.size() - 1);
        this.actionRemove.setEnabled(indices.length > 0);
    }

    public String[] getData() {
        Object[] objects = this.model.toArray();
        String[] strings = new String[objects.length];
        System.arraycopy(objects, 0, strings, 0, objects.length);
        return strings;
    }

    public void setData(String[] filenames) {
        this.model.clear();
        int i = 0;
        while (i < filenames.length) {
            this.model.addElement(new File(filenames[i]).getAbsolutePath());
            ++i;
        }
        if (filenames.length > 0) {
            this.list.setSelectedIndex(0);
        }
        this.updateActionEnabling();
    }

    public static void main(String[] args) throws Exception {
        ClasspathPanel pane = new ClasspathPanel();
        pane.setData(new String[]{"D:/temp/a.jar", "D:/temp/classes"});
        GUIUtils.createJDialog(null, pane, null, true).show();
        System.out.println("DUMP pane.getData() = " + ArrayUtils.toString(pane.getData()));
    }
}

