/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.configuration;

import com.sap.engine.library.bytecode.gui.common.AbstractInternationalizedAction;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class OkCancelWrapperPanel
extends JPanel {
    private boolean result = false;
    private final Action actionOk = new AbstractInternationalizedAction("OK", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            Window w = SwingUtilities.getWindowAncestor(OkCancelWrapperPanel.this);
            if (w != null) {
                OkCancelWrapperPanel.this.result = true;
                w.hide();
            }
        }
    };
    private final AbstractInternationalizedAction actionCancel = new AbstractInternationalizedAction("CANCEL", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            Window w = SwingUtilities.getWindowAncestor(OkCancelWrapperPanel.this);
            if (w != null) {
                OkCancelWrapperPanel.this.result = false;
                w.hide();
            }
        }
    };

    OkCancelWrapperPanel() {
        super(new BorderLayout(5, 5));
    }

    OkCancelWrapperPanel(JComponent content) {
        this();
        this.init(content);
    }

    void init(JComponent content) {
        super.setBorder(GUIUtils.EMPTY_BORDER_1);
        super.add((Component)content, "Center");
        JPanel buttonsPanel = new JPanel();
        JPanel buttonsInnerPanel = new JPanel(new GridLayout(1, 0, 5, 5));
        buttonsInnerPanel.add(GUIUtils.createJButton(this.actionOk));
        buttonsInnerPanel.add(GUIUtils.createJButton(this.actionCancel));
        buttonsPanel.add(buttonsInnerPanel);
        super.add((Component)buttonsPanel, "South");
        GUIUtils.setKeyStrokes(this, new Action[]{this.actionOk, this.actionCancel});
    }

    public boolean getResult() {
        return this.result;
    }

    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.actionOk.setEnabled(isEnabled);
    }
}

