/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.configuration;

import com.sap.engine.library.bytecode.gui.configuration.ConfigurationEntry;
import com.sap.engine.library.bytecode.gui.configuration.EntryVisualizer;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.XProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class EntryVisualizerForString
extends JPanel
implements EntryVisualizer,
PropertyChangeListener {
    private ConfigurationEntry entry;
    private String propertyName;
    private XProperties originalProperties;
    private XProperties currentProperties;
    protected final JLabel label;
    protected final JTextField textField;

    public EntryVisualizerForString() {
        super(new BorderLayout(5, 5));
        super.setBorder(GUIUtils.EMPTY_BORDER_1);
        this.label = new JLabel();
        this.textField = new JTextField(20);
        this.textField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                EntryVisualizerForString.this.textField.selectAll();
            }
        });
        this.textField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                EntryVisualizerForString.this.currentProperties.setProperty(EntryVisualizerForString.this.propertyName, EntryVisualizerForString.this.textField.getText());
            }
        });
        this.label.setLabelFor(this.textField);
        super.add((Component)this.label, "West");
        super.add((Component)this.textField, "Center");
    }

    public JComponent init(ConfigurationEntry entry, XProperties originalProperties, XProperties currentProperties) {
        this.entry = entry;
        this.propertyName = entry.getPropertyName();
        this.originalProperties = originalProperties;
        this.currentProperties = currentProperties;
        this.label.setText(entry.getDisplayedName());
        char mnemonic = entry.getDisplayedMnemonic();
        if (mnemonic != '\u0000') {
            this.label.setDisplayedMnemonic(mnemonic);
        }
        originalProperties.addPropertyChangeListener(this.propertyName, this);
        currentProperties.addPropertyChangeListener(this.propertyName, this);
        return this;
    }

    public final JComponent getComponent() {
        return this;
    }

    public final ConfigurationEntry getEntry() {
        return this.entry;
    }

    public final void propertyChange(PropertyChangeEvent event) {
        String s = (String)event.getNewValue();
        if (!s.equals(this.textField.getText())) {
            this.textField.setText(s);
        }
    }

    public final void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.label != null) {
            this.label.setForeground(fg);
        }
    }

    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textField.setEnabled(enabled);
    }
}

