/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.configuration;

import com.sap.engine.library.bytecode.gui.configuration.ConfigurationEntry;
import com.sap.engine.library.bytecode.gui.configuration.EntryVisualizer;
import com.sap.engine.library.bytecode.gui.filechooser.XFileChooser;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.XProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

final class EntryVisualizerForFile
extends JPanel
implements EntryVisualizer,
PropertyChangeListener {
    private ConfigurationEntry entry;
    private String propertyName;
    private XProperties originalProperties;
    private XProperties currentProperties;
    private final XFileChooser chooser;
    private final JLabel label;
    private final JTextField textField;
    private final JButton button;
    private final Color normalColour;
    private final Action actionBrowse = new AbstractAction("..."){

        public void actionPerformed(ActionEvent e) {
            String value = EntryVisualizerForFile.this.currentProperties.getProperty(EntryVisualizerForFile.this.propertyName);
            if (value != null && value.length() != 0) {
                EntryVisualizerForFile.this.chooser.setSelectedFile(new File(value));
            } else {
                EntryVisualizerForFile.this.chooser.setSelectedFiles(null);
            }
            int x = EntryVisualizerForFile.this.chooser.showOpenDialog(EntryVisualizerForFile.this);
            if (x == 0) {
                File file = EntryVisualizerForFile.this.chooser.getSelectedFile();
                EntryVisualizerForFile.this.currentProperties.setProperty(EntryVisualizerForFile.this.propertyName, file == null ? "" : file.getAbsolutePath());
            }
        }
    };

    public EntryVisualizerForFile() {
        super(new BorderLayout(5, 5));
        super.setBorder(GUIUtils.EMPTY_BORDER_1);
        this.label = new JLabel();
        this.textField = new JTextField(20);
        this.chooser = new XFileChooser();
        this.chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return !f.isDirectory();
            }

            public String getDescription() {
                return null;
            }
        });
        this.chooser.setSelectionMode(1);
        this.button = GUIUtils.createJButton(this.actionBrowse);
        this.button.setPreferredSize(new Dimension(20, 20));
        this.label.setLabelFor(this.chooser);
        super.add((Component)this.button, "East");
        super.add((Component)this.textField, "Center");
        super.add((Component)this.label, "West");
        this.textField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                EntryVisualizerForFile.this.textField.selectAll();
            }
        });
        this.textField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                EntryVisualizerForFile.this.currentProperties.setProperty(EntryVisualizerForFile.this.propertyName, EntryVisualizerForFile.this.textField.getText());
            }
        });
        this.normalColour = this.textField.getForeground();
    }

    public JComponent init(ConfigurationEntry entry, XProperties originalProperties, XProperties currentProperties) {
        this.entry = entry;
        this.propertyName = entry.getPropertyName();
        this.originalProperties = originalProperties;
        this.currentProperties = currentProperties;
        this.label.setText(entry.getDisplayedName());
        char mnemonic = entry.getDisplayedMnemonic();
        if (mnemonic != '\u0000') {
            this.label.setDisplayedMnemonic(mnemonic);
        }
        originalProperties.addPropertyChangeListener(this.propertyName, this);
        currentProperties.addPropertyChangeListener(this.propertyName, this);
        return this;
    }

    public JComponent getComponent() {
        return this;
    }

    public final ConfigurationEntry getEntry() {
        return this.entry;
    }

    public void propertyChange(PropertyChangeEvent event) {
        File file;
        String value = (String)event.getNewValue();
        if (!value.equals(this.textField.getText())) {
            this.textField.setText(value);
        }
        this.textField.setForeground((file = new File(value)).exists() && !file.isDirectory() ? this.normalColour : Color.red);
    }

    public final void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.label != null) {
            this.label.setForeground(fg);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textField.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }
}

