/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.configuration;

import com.sap.engine.library.bytecode.gui.configuration.ConfigurationEntry;
import com.sap.engine.library.bytecode.gui.configuration.EntryVisualizer;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.XProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

final class EntryVisualizerForEnumeration
extends JPanel
implements EntryVisualizer,
PropertyChangeListener {
    private ConfigurationEntry entry;
    private final JLabel label;
    private final JComboBox comboBox;
    private XProperties originalProperties;
    private XProperties currentProperties;

    EntryVisualizerForEnumeration() {
        super(new BorderLayout(5, 5));
        super.setBorder(GUIUtils.EMPTY_BORDER_1);
        this.label = new JLabel();
        this.comboBox = new JComboBox();
        super.add((Component)this.label, "West");
        super.add((Component)this.comboBox, "Center");
        this.label.setLabelFor(this.comboBox);
    }

    public JComponent init(ConfigurationEntry entry, XProperties originalProperties, final XProperties currentProperties) {
        this.entry = entry;
        this.originalProperties = originalProperties;
        this.currentProperties = currentProperties;
        final String propertyName = entry.getPropertyName();
        currentProperties.addPropertyChangeListener(propertyName, this);
        originalProperties.addPropertyChangeListener(propertyName, this);
        this.label.setText(entry.getDisplayedName());
        char displayedMnemonic = entry.getDisplayedMnemonic();
        if (displayedMnemonic != '\u0000') {
            this.label.setDisplayedMnemonic(displayedMnemonic);
        }
        String[] typeParameters = entry.getTypeParameters();
        this.comboBox.setModel(new DefaultComboBoxModel<String>(typeParameters));
        this.comboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                String value = (String)EntryVisualizerForEnumeration.this.comboBox.getSelectedItem();
                if (value != null) {
                    currentProperties.setProperty(propertyName, value);
                }
            }
        });
        return this;
    }

    public JComponent getComponent() {
        return this;
    }

    public ConfigurationEntry getEntry() {
        return this.entry;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.comboBox.setSelectedItem(event.getNewValue());
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.comboBox.setEnabled(enabled);
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.label != null) {
            this.label.setForeground(fg);
        }
    }
}

