/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.configuration;

import com.sap.engine.library.bytecode.gui.configuration.ConfigurationEntry;
import com.sap.engine.library.bytecode.gui.configuration.EntryVisualizer;
import com.sap.engine.library.bytecode.gui.configuration.OkCancelWrapperPanel;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.XProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

final class EntryVisualizerForColour
extends JPanel
implements EntryVisualizer,
PropertyChangeListener {
    private ConfigurationEntry entry;
    private String propertyName;
    private XProperties originalProperties;
    private XProperties currentProperties;
    private final JLabel label;
    private final JButton button;
    private JDialog dialog;
    private JColorChooser chooser;
    private OkCancelWrapperPanel wrapperPanel;
    private final Action actionChoose = new AbstractAction("..."){

        public void actionPerformed(ActionEvent e) {
            if (EntryVisualizerForColour.this.dialog == null) {
                EntryVisualizerForColour.this.chooser = new JColorChooser();
                EntryVisualizerForColour.this.wrapperPanel = new OkCancelWrapperPanel(EntryVisualizerForColour.this.chooser);
                EntryVisualizerForColour.this.dialog = GUIUtils.createJDialog(EntryVisualizerForColour.this, EntryVisualizerForColour.this.wrapperPanel, EntryVisualizerForColour.this.propertyName, true);
            }
            EntryVisualizerForColour.this.chooser.setColor(GUIUtils.stringToColour(EntryVisualizerForColour.this.currentProperties.getProperty(EntryVisualizerForColour.this.propertyName)));
            EntryVisualizerForColour.this.dialog.show();
            if (EntryVisualizerForColour.this.wrapperPanel.getResult()) {
                EntryVisualizerForColour.this.currentProperties.setProperty(EntryVisualizerForColour.this.propertyName, GUIUtils.colourToString(EntryVisualizerForColour.this.chooser.getColor()));
            }
        }
    };

    public EntryVisualizerForColour() {
        super(new BorderLayout(5, 5));
        super.setBorder(GUIUtils.EMPTY_BORDER_1);
        this.label = new JLabel();
        this.button = GUIUtils.createJButton(this.actionChoose);
        this.button.setPreferredSize(new Dimension(20, 20));
        this.label.setLabelFor(this.button);
        super.add((Component)this.button, "East");
        super.add((Component)this.label, "Center");
    }

    public JComponent init(ConfigurationEntry entry, XProperties originalProperties, XProperties currentProperties) {
        this.entry = entry;
        this.propertyName = entry.getPropertyName();
        this.originalProperties = originalProperties;
        this.currentProperties = currentProperties;
        this.label.setText(entry.getDisplayedName());
        char mnemonic = entry.getDisplayedMnemonic();
        if (mnemonic != '\u0000') {
            this.label.setDisplayedMnemonic(mnemonic);
        }
        originalProperties.addPropertyChangeListener(this.propertyName, this);
        currentProperties.addPropertyChangeListener(this.propertyName, this);
        return this;
    }

    public JComponent getComponent() {
        return this;
    }

    public final ConfigurationEntry getEntry() {
        return this.entry;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.button.setBackground(GUIUtils.stringToColour((String)event.getNewValue()));
    }

    public final void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.label != null) {
            this.label.setForeground(fg);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }
}

