/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.configuration;

import com.sap.engine.library.bytecode.gui.configuration.ConfigurationEntry;
import com.sap.engine.library.bytecode.gui.configuration.EntryVisualizer;
import com.sap.engine.library.bytecode.gui.configuration.OkCancelWrapperPanel;
import com.sap.engine.library.bytecode.gui.filechooser.ClasspathPanel;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.StringUtils;
import com.sap.engine.library.bytecode.misc.XProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

final class EntryVisualizerForClasspath
extends JPanel
implements EntryVisualizer,
PropertyChangeListener {
    private String propertyName;
    private XProperties originalProperties;
    private XProperties currentProperties;
    private ConfigurationEntry entry;
    private final JLabel label;
    private final JTextField textField;
    private final JButton button;
    private final ClasspathPanel classpathPanel;
    private final Action actionEdit = new AbstractAction("..."){

        public void actionPerformed(ActionEvent e) {
            String value = EntryVisualizerForClasspath.this.currentProperties.getProperty(EntryVisualizerForClasspath.this.propertyName);
            if (value == null) {
                value = "";
            }
            EntryVisualizerForClasspath.this.classpathPanel.setData(StringUtils.splitAndTrim(value, ';'));
            OkCancelWrapperPanel wrapperPanel = new OkCancelWrapperPanel(EntryVisualizerForClasspath.this.classpathPanel);
            wrapperPanel.setPreferredSize(new Dimension(300, 250));
            JDialog dialog = GUIUtils.createJDialog(EntryVisualizerForClasspath.this.button, wrapperPanel, EntryVisualizerForClasspath.this.entry.getDisplayedName(), true);
            dialog.show();
            if (wrapperPanel.getResult()) {
                EntryVisualizerForClasspath.this.currentProperties.setProperty(EntryVisualizerForClasspath.this.propertyName, StringUtils.concat(EntryVisualizerForClasspath.this.classpathPanel.getData(), ';'));
            }
        }
    };

    public EntryVisualizerForClasspath() {
        super(new BorderLayout(5, 5));
        super.setBorder(GUIUtils.EMPTY_BORDER_1);
        this.label = new JLabel();
        this.textField = new JTextField(20);
        this.textField.setEditable(false);
        this.textField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                EntryVisualizerForClasspath.this.textField.selectAll();
            }
        });
        this.button = GUIUtils.createJButton(this.actionEdit);
        this.button.setPreferredSize(new Dimension(20, 20));
        this.label.setLabelFor(this.button);
        super.add((Component)this.label, "West");
        super.add((Component)this.textField, "Center");
        super.add((Component)this.button, "East");
        this.classpathPanel = new ClasspathPanel();
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("lookAndFeel")) {
                    SwingUtilities.updateComponentTreeUI(EntryVisualizerForClasspath.this.classpathPanel);
                }
            }
        });
    }

    public JComponent init(ConfigurationEntry entry, XProperties originalProperties, XProperties currentProperties) {
        this.entry = entry;
        this.originalProperties = originalProperties;
        this.currentProperties = currentProperties;
        this.propertyName = entry.getPropertyName();
        this.label.setText(entry.getDisplayedName());
        char mnemonic = entry.getDisplayedMnemonic();
        if (mnemonic != '\u0000') {
            this.label.setDisplayedMnemonic(mnemonic);
        }
        originalProperties.addPropertyChangeListener(this.propertyName, this);
        currentProperties.addPropertyChangeListener(this.propertyName, this);
        return this;
    }

    public JComponent getComponent() {
        return this;
    }

    public final ConfigurationEntry getEntry() {
        return this.entry;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.textField.setText((String)event.getNewValue());
    }

    public final void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.label != null) {
            this.label.setForeground(fg);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }
}

