/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.configuration;

import com.sap.engine.library.bytecode.gui.configuration.ConfigurationEntry;
import com.sap.engine.library.bytecode.gui.configuration.EntryVisualizer;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.XProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

final class EntryVisualizerForBoolean
extends JPanel
implements EntryVisualizer,
PropertyChangeListener {
    private static final Border EMPTY_BORDER_0_0_0_3 = BorderFactory.createEmptyBorder(0, 0, 0, 3);
    private ConfigurationEntry entry;
    private String propertyName;
    private XProperties currentProperties;
    private final JCheckBox checkBox;
    private final JLabel label = new JLabel();

    public EntryVisualizerForBoolean() {
        super(new BorderLayout(5, 5));
        this.label.setOpaque(true);
        this.checkBox = new JCheckBox((String)null);
        this.checkBox.setOpaque(false);
        this.checkBox.setBorder(GUIUtils.EMPTY_BORDER_1);
        this.checkBox.setMargin(new Insets(0, 0, 0, 0));
        this.label.setLabelFor(this.checkBox);
        super.add((Component)this.checkBox, "West");
        super.add((Component)this.label, "Center");
        this.checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EntryVisualizerForBoolean.this.currentProperties.setProperty(EntryVisualizerForBoolean.this.propertyName, EntryVisualizerForBoolean.this.checkBox.isSelected() ? "1" : "0");
            }
        });
    }

    public JComponent init(ConfigurationEntry entry, XProperties originalProperties, XProperties currentProperties) {
        this.entry = entry;
        this.currentProperties = currentProperties;
        this.propertyName = entry.getPropertyName();
        this.label.setText(entry.getDisplayedName());
        char mnemonic = entry.getDisplayedMnemonic();
        if (mnemonic != '\u0000') {
            this.label.setDisplayedMnemonic(mnemonic);
        }
        originalProperties.addPropertyChangeListener(this.propertyName, this);
        currentProperties.addPropertyChangeListener(this.propertyName, this);
        return this;
    }

    public JComponent getComponent() {
        return this;
    }

    public final ConfigurationEntry getEntry() {
        return this.entry;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.checkBox.setSelected("1".equals(event.getNewValue()));
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.checkBox.setEnabled(enabled);
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.label != null) {
            this.label.setForeground(fg);
        }
    }

    public void setBackground(Color bg) {
        if (this.label != null) {
            this.label.setBackground(bg);
        }
    }
}

