/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.configuration;

import com.sap.engine.library.bytecode.gui.configuration.ConfigurationEntry;
import com.sap.engine.library.bytecode.misc.StringUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

public final class ConfigurationScheme
implements Serializable {
    private static final String SPECIAL_PROPERTY_ORDER = "~order";
    private static final String SPECIAL_PROPERTY_DEBUG = "~debug";
    private static final String META_PROPERTY_TYPE = "type";
    private static final String META_PROPERTY_TEXT = "text";
    private static final String META_PROPERTY_DESCRIPTION = "description";
    private static final String META_PROPERTY_PARENT = "parent";
    private static final String META_PROPERTY_DEPENDENCIES = "dependencies";
    private static final String[] ALL_META_PROPERTIES = new String[]{"type", "text", "description", "parent", "dependencies"};
    private ConfigurationEntry root;
    static /* synthetic */ Class class$com$sap$engine$library$bytecode$gui$configuration$ConfigurationScheme;

    public ConfigurationScheme() {
    }

    /*
     * Unable to fully structure code
     */
    public ConfigurationScheme(Properties properties) {
        block33: {
            super();
            isDebug = properties.getProperty("~debug") != null;
            errors = isDebug != false ? new ArrayList<String>() : null;
            orderString = properties.getProperty("~order");
            propertyNamesList = new ArrayList<String>();
            if (orderString == null) break block33;
            orderArray = StringUtils.split(orderString, ',');
            i = 0;
            while (i < orderArray.length) {
                propertyName = orderArray[i];
                if (!isDebug) ** GOTO lbl-1000
                if (!properties.containsKey(propertyName)) {
                    errors.add("The property name '" + propertyName + "' mentioned in ~order is not described.");
                } else if (propertyNamesList.contains(propertyName)) {
                    errors.add("Property name '" + propertyName + "' mentioned more than once in ~order.");
                } else lbl-1000:
                // 2 sources

                {
                    propertyNamesList.add(propertyName);
                }
                ++i;
            }
        }
        enum = properties.propertyNames();
        while (enum.hasMoreElements()) {
            propertyName = (String)enum.nextElement();
            if (propertyNamesList.contains(propertyName) || propertyName.startsWith("~")) continue;
            propertyNamesList.add(propertyName);
        }
        propertyNames = propertyNamesList.toArray(new String[propertyNamesList.size()]);
        h = new Hashtable<String, Object[]>();
        i = 0;
        while (i < propertyNames.length) {
            propertyName = propertyNames[i];
            metaProperties = StringUtils.parseProperties((String)properties.get(propertyName));
            type = metaProperties.getProperty("type");
            typeParameters = null;
            if (type == null) {
                type = "string";
            } else {
                typeIndexOfBracket = type.indexOf(40);
                if (typeIndexOfBracket != -1) {
                    if (type.charAt(type.length() - 1) != ')') {
                        errors.add("'(' not closed with ')'. Check if there are any accidental ','-s in between.");
                        typeParametersString = type.substring(typeIndexOfBracket + 1);
                    } else {
                        typeParametersString = type.substring(typeIndexOfBracket + 1, type.length() - 1);
                    }
                    typeParameters = StringUtils.split(typeParametersString, ';');
                    type = type.substring(0, typeIndexOfBracket);
                }
                found = false;
                j = 0;
                while (j < ConfigurationEntry.ALL_TYPES.length) {
                    if (type.equals(ConfigurationEntry.ALL_TYPES[j])) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    if (isDebug) {
                        errors.add("Type '" + type + "' of property '" + propertyName + "' not recognized.");
                    }
                    type = "string";
                }
            }
            description = metaProperties.getProperty("description");
            text = metaProperties.getProperty("text");
            if (text == null) {
                text = propertyName;
            }
            parentName = metaProperties.getProperty("parent");
            dependenciesString = metaProperties.getProperty("dependencies");
            dependenciesArray = dependenciesString == null ? null : StringUtils.split(dependenciesString, ';');
            entry = new ConfigurationEntry(text, type.equals("label") != false ? null : propertyName, type, typeParameters, description, null);
            h.put(propertyName, new Object[]{entry, parentName, dependenciesArray});
            if (isDebug) {
                j = 0;
                while (j < ConfigurationScheme.ALL_META_PROPERTIES.length) {
                    metaProperties.remove(ConfigurationScheme.ALL_META_PROPERTIES[j]);
                    ++j;
                }
                if (metaProperties.size() != 0) {
                    errors.add("Unrecognized meta data for property '" + propertyName + "': " + metaProperties);
                }
            }
            ++i;
        }
        rootEntry = new ConfigurationEntry("", null, "root", null, null, null);
        i = 0;
        while (i < propertyNames.length) {
            propertyName = propertyNames[i];
            data = (Object[])h.get(propertyName);
            entry = (ConfigurationEntry)data[0];
            parentEntry = null;
            parentName = (String)data[1];
            if (parentName != null) {
                parentData = (Object[])h.get(parentName);
                if (parentData != null) {
                    parentEntry = (ConfigurationEntry)parentData[0];
                } else if (isDebug) {
                    errors.add("Parent '" + parentName + "' of property '" + propertyName + "' is not described.");
                }
            }
            if (parentEntry == null) {
                parentEntry = rootEntry;
            }
            parentEntry.addChild(entry);
            dependencyNames = (String[])data[2];
            if (dependencyNames != null) {
                dependencyEntryList = new ArrayList<Object>();
                j = 0;
                while (j < dependencyNames.length) {
                    dependencyName = dependencyNames[j];
                    dependencyData = (Object[])h.get(dependencyName);
                    if (dependencyData != null) {
                        dependencyEntryList.add(dependencyData[0]);
                    } else if (isDebug) {
                        errors.add("Dependency '" + dependencyName + "' of property '" + propertyName + "' is not described.");
                    }
                    ++j;
                }
                dependencyEntries = dependencyEntryList.toArray(new ConfigurationEntry[dependencyEntryList.size()]);
                entry.setDependencies(dependencyEntries);
            }
            ++i;
        }
        this.setRoot(rootEntry);
        if (isDebug) {
            errorsArray = errors.toArray(new String[errors.size()]);
            i = 0;
            while (i < errorsArray.length) {
                System.out.println("Bad configuration: " + errorsArray[i]);
                ++i;
            }
        }
    }

    public ConfigurationEntry getRoot() {
        return this.root;
    }

    public void setRoot(ConfigurationEntry root) {
        this.root = root;
    }

    public static ConfigurationScheme createSampleScheme() {
        Properties p = new Properties();
        try {
            p.load((class$com$sap$engine$library$bytecode$gui$configuration$ConfigurationScheme == null ? (class$com$sap$engine$library$bytecode$gui$configuration$ConfigurationScheme = ConfigurationScheme.class$("com.sap.engine.library.bytecode.gui.configuration.ConfigurationScheme")) : class$com$sap$engine$library$bytecode$gui$configuration$ConfigurationScheme).getResourceAsStream("sample-meta.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ConfigurationScheme(p);
    }

    public static Properties createSampleData() {
        Properties p = new Properties();
        try {
            p.load((class$com$sap$engine$library$bytecode$gui$configuration$ConfigurationScheme == null ? (class$com$sap$engine$library$bytecode$gui$configuration$ConfigurationScheme = ConfigurationScheme.class$("com.sap.engine.library.bytecode.gui.configuration.ConfigurationScheme")) : class$com$sap$engine$library$bytecode$gui$configuration$ConfigurationScheme).getResourceAsStream("sample.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return p;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

