/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.configuration;

import com.sap.engine.library.bytecode.gui.configuration.ConfigurationCellRendererAndEditor;
import com.sap.engine.library.bytecode.gui.configuration.ConfigurationEntry;
import com.sap.engine.library.bytecode.gui.configuration.ConfigurationScheme;
import com.sap.engine.library.bytecode.gui.configuration.EntryVisualizer;
import com.sap.engine.library.bytecode.gui.configuration.EntryVisualizerForBoolean;
import com.sap.engine.library.bytecode.gui.configuration.EntryVisualizerForClasspath;
import com.sap.engine.library.bytecode.gui.configuration.EntryVisualizerForColour;
import com.sap.engine.library.bytecode.gui.configuration.EntryVisualizerForEnumeration;
import com.sap.engine.library.bytecode.gui.configuration.EntryVisualizerForFile;
import com.sap.engine.library.bytecode.gui.configuration.EntryVisualizerForInteger;
import com.sap.engine.library.bytecode.gui.configuration.EntryVisualizerForLabel;
import com.sap.engine.library.bytecode.gui.configuration.EntryVisualizerForString;
import com.sap.engine.library.bytecode.misc.XProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public final class ConfigurationPanel
extends JPanel {
    public static final String IS_DATA_CHANGED_PROPERTY = "isDataChanged";
    private final DefaultTreeModel model;
    private final JTree tree;
    private final JLabel statusLabel;
    private final XProperties support = new XProperties(new String[]{"isDataChanged"}, null);
    private final XProperties originalProperties = new XProperties();
    private final XProperties currentProperties = new XProperties();

    public ConfigurationPanel(ConfigurationScheme scheme) {
        super(new BorderLayout());
        this.support.setProperty(IS_DATA_CHANGED_PROPERTY, "0");
        this.model = new DefaultTreeModel(this.createDefaultMutableTreeNode(scheme.getRoot()));
        this.tree = new JTree(this.model){

            public String getToolTipText(MouseEvent event) {
                TreePath path = this.getPathForLocation(event.getX(), event.getY());
                if (path == null) {
                    return null;
                }
                Object lastPathComponent = path.getLastPathComponent();
                if (lastPathComponent == null || !(lastPathComponent instanceof DefaultMutableTreeNode)) {
                    return null;
                }
                Object userObject = ((DefaultMutableTreeNode)lastPathComponent).getUserObject();
                if (userObject == null || !(userObject instanceof EntryVisualizer)) {
                    return null;
                }
                EntryVisualizer visualizer = (EntryVisualizer)userObject;
                return visualizer.getEntry().getHelp();
            }
        };
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        ConfigurationCellRendererAndEditor rendererAndEditor = new ConfigurationCellRendererAndEditor(this.tree);
        this.tree.setCellRenderer(rendererAndEditor);
        this.tree.setCellEditor(rendererAndEditor);
        this.tree.setLargeModel(false);
        this.tree.setEditable(true);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setRowHeight(20);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setSelectionRow(0);
        JScrollPane scrollPane = new JScrollPane(this.tree);
        scrollPane.setPreferredSize(new Dimension(500, 250));
        super.add((Component)scrollPane, "Center");
        this.statusLabel = new JLabel();
        this.statusLabel.setFont(new Font("tahoma", 2, 12));
        super.add((Component)this.statusLabel, "South");
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                EntryVisualizer visualizer = ConfigurationPanel.this.getSelectedEntryVisualizer();
                if (visualizer == null) {
                    ConfigurationPanel.this.statusLabel.setText("");
                } else {
                    String description = visualizer.getEntry().getHelp();
                    ConfigurationPanel.this.statusLabel.setText(description == null ? "" : description);
                }
            }
        });
        PropertyChangeListener listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String propertyName = event.getPropertyName();
                String originalValue = ConfigurationPanel.this.originalProperties.getProperty(propertyName);
                String currentValue = ConfigurationPanel.this.currentProperties.getProperty(propertyName);
                if (originalValue != null && currentValue != null) {
                    boolean b = ((Hashtable)ConfigurationPanel.this.originalProperties).equals(ConfigurationPanel.this.currentProperties);
                    ConfigurationPanel.this.support.setProperty(ConfigurationPanel.IS_DATA_CHANGED_PROPERTY, !b ? "1" : "0");
                } else if (originalValue != null || currentValue != null) {
                    ConfigurationPanel.this.support.setProperty(ConfigurationPanel.IS_DATA_CHANGED_PROPERTY, "1");
                }
            }
        };
        this.originalProperties.addPropertyChangeListener(listener);
        this.currentProperties.addPropertyChangeListener(listener);
    }

    private EntryVisualizer getSelectedEntryVisualizer() {
        Object userObject;
        Object lastPathComponent;
        TreePath path = this.tree.getSelectionPath();
        if (path != null && (lastPathComponent = path.getLastPathComponent()) instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)lastPathComponent).getUserObject()) instanceof EntryVisualizer) {
            return (EntryVisualizer)userObject;
        }
        return null;
    }

    private DefaultMutableTreeNode createDefaultMutableTreeNode(ConfigurationEntry entry) {
        DefaultMutableTreeNode r;
        EntryVisualizer visualizer = ConfigurationPanel.createVisualizer(entry);
        final JComponent component = visualizer.getComponent();
        component.putClientProperty("help", entry.getHelp());
        component.setOpaque(true);
        final ConfigurationEntry[] dependencies = entry.getDependencies();
        if (dependencies != null && dependencies.length != 0) {
            PropertyChangeListener listener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    boolean newIsEnabled;
                    boolean newValue = "1".equals(event.getNewValue());
                    boolean oldIsEnabled = component.isEnabled();
                    if (!newValue) {
                        newIsEnabled = false;
                    } else {
                        newIsEnabled = true;
                        int i = 0;
                        while (i < dependencies.length) {
                            if (!"1".equals(ConfigurationPanel.this.currentProperties.getProperty(dependencies[i].getPropertyName()))) {
                                newIsEnabled = false;
                                return;
                            }
                            ++i;
                        }
                    }
                    if (oldIsEnabled != newIsEnabled) {
                        component.setEnabled(newIsEnabled);
                        ConfigurationPanel.this.tree.repaint();
                    }
                }
            };
            int i = 0;
            while (i < dependencies.length) {
                this.currentProperties.addPropertyChangeListener(dependencies[i].getPropertyName(), listener);
                ++i;
            }
        }
        if (visualizer != null) {
            visualizer.init(entry, this.originalProperties, this.currentProperties);
            r = new DefaultMutableTreeNode(visualizer);
        } else {
            r = new DefaultMutableTreeNode("???");
        }
        ConfigurationEntry child = entry.getFirstChild();
        while (child != null) {
            r.add(this.createDefaultMutableTreeNode(child));
            child = child.getRightSibling();
        }
        return r;
    }

    private static EntryVisualizer createVisualizer(ConfigurationEntry entry) {
        String t = entry.getType();
        if (t.equals("root") || t.equals("label")) {
            return new EntryVisualizerForLabel();
        }
        if (t.equals("boolean")) {
            return new EntryVisualizerForBoolean();
        }
        if (t.equals("int")) {
            return new EntryVisualizerForInteger();
        }
        if (t.equals("classpath")) {
            return new EntryVisualizerForClasspath();
        }
        if (t.equals("file")) {
            return new EntryVisualizerForFile();
        }
        if (t.equals("colour")) {
            return new EntryVisualizerForColour();
        }
        if (t.equals("enumeration")) {
            return new EntryVisualizerForEnumeration();
        }
        return new EntryVisualizerForString();
    }

    public void setData(Properties p) {
        this.originalProperties.set(p);
        this.currentProperties.set(p);
    }

    public Properties getData() {
        return (Properties)this.currentProperties.clone();
    }

    public boolean isChanged() {
        return ((Hashtable)this.originalProperties).equals(this.currentProperties);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (propertyName.equals(IS_DATA_CHANGED_PROPERTY)) {
            this.support.addPropertyChangeListener(listener);
        } else {
            super.addPropertyChangeListener(propertyName, listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        try {
            this.support.removePropertyChangeListener(listener);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            super.removePropertyChangeListener(listener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setOriginalPropertiesToCurrentProperties() {
        this.originalProperties.set(this.currentProperties);
    }
}

