/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.configuration;

import java.io.Serializable;

public final class ConfigurationEntry
implements Serializable {
    private static final ConfigurationEntry[] CONFIGURATION_ENTRY_ARRAY_0 = new ConfigurationEntry[0];
    public static final String T_ROOT = "root";
    public static final String T_BOOLEAN = "boolean";
    public static final String T_INTEGER = "int";
    public static final String T_CLASSPATH = "classpath";
    public static final String T_STRING = "string";
    public static final String T_FILE = "file";
    public static final String T_LABEL = "label";
    public static final String T_COLOUR = "colour";
    public static final String T_ENUMERATION = "enumeration";
    public static final String[] ALL_TYPES = new String[]{"root", "boolean", "int", "classpath", "string", "file", "label", "colour", "enumeration"};
    public static final String[] OLD_TYPES = new String[]{null, "root", "boolean", "int", "classpath", "string", "file", "label", "colour"};
    private String type;
    private String[] typeParameters;
    private String propertyName;
    private String displayedName;
    private char displayedMnemonic;
    private String help;
    private ConfigurationEntry[] dependencies;
    private ConfigurationEntry parent;
    private ConfigurationEntry firstChild;
    private ConfigurationEntry lastChild;
    private ConfigurationEntry rightSibling;

    public ConfigurationEntry(String formattedDisplayedName, String propertyName, int type, String help, ConfigurationEntry[] dependencies) {
        this(formattedDisplayedName, propertyName, OLD_TYPES[type], null, help, dependencies);
    }

    public ConfigurationEntry(String formattedDisplayedName, String propertyName, String type, String help, ConfigurationEntry[] dependencies) {
        this(formattedDisplayedName, propertyName, type, null, help, dependencies);
    }

    public ConfigurationEntry(String formattedDisplayedName, String propertyName, String type, String[] typeParameters, String help, ConfigurationEntry[] dependencies) {
        this.help = help;
        this.type = type;
        this.typeParameters = typeParameters;
        this.propertyName = propertyName;
        int indexOfAmpersand = formattedDisplayedName.indexOf(38);
        if (indexOfAmpersand == -1 || indexOfAmpersand == formattedDisplayedName.length() - 1) {
            this.displayedName = formattedDisplayedName;
            this.displayedMnemonic = '\u0000';
        } else {
            this.displayedMnemonic = formattedDisplayedName.charAt(indexOfAmpersand + 1);
            this.displayedName = formattedDisplayedName.substring(0, indexOfAmpersand) + formattedDisplayedName.substring(indexOfAmpersand + 1);
            if (this.displayedMnemonic == '&') {
                this.displayedMnemonic = '\u0000';
            }
        }
        this.help = help;
        this.type = type;
        this.propertyName = propertyName;
        this.setDependencies(dependencies);
    }

    String getType() {
        return this.type;
    }

    String[] getTypeParameters() {
        return this.typeParameters;
    }

    String getPropertyName() {
        return this.propertyName;
    }

    String getDisplayedName() {
        return this.displayedName;
    }

    public void addChild(ConfigurationEntry child) {
        if (child.parent != null) {
            throw new IllegalArgumentException();
        }
        child.parent = this;
        if (this.firstChild == null) {
            this.firstChild = this.lastChild = child;
        } else {
            this.lastChild.rightSibling = child;
            this.lastChild = child;
        }
    }

    public ConfigurationEntry getParent() {
        return this.parent;
    }

    public ConfigurationEntry getFirstChild() {
        return this.firstChild;
    }

    public ConfigurationEntry getLastChild() {
        return this.lastChild;
    }

    public ConfigurationEntry getRightSibling() {
        return this.rightSibling;
    }

    public char getDisplayedMnemonic() {
        return this.displayedMnemonic;
    }

    public String getHelp() {
        return this.help;
    }

    public void setDependencies(ConfigurationEntry[] dependencies) {
        this.dependencies = dependencies == null ? null : (ConfigurationEntry[])dependencies.clone();
    }

    public ConfigurationEntry[] getDependencies() {
        return this.dependencies == null ? CONFIGURATION_ENTRY_ARRAY_0 : (ConfigurationEntry[])this.dependencies.clone();
    }
}

