/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.configuration;

import com.sap.engine.library.bytecode.gui.configuration.ConfigurationPanel;
import com.sap.engine.library.bytecode.gui.configuration.ConfigurationScheme;
import com.sap.engine.library.bytecode.gui.configuration.OkCancelWrapperPanel;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import java.awt.Dialog;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.border.CompoundBorder;

public final class ConfigurationDialog
extends JDialog {
    private static final CompoundBorder CONFIGURATION_PANEL_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), GUIUtils.EMPTY_BORDER_5);
    private ConfigurationPanel configurationPanel;
    private OkCancelWrapperPanel okCancelWrapperPanel;
    private Properties referentProperties;

    public ConfigurationDialog(Dialog owner, String title, boolean modal, ConfigurationScheme scheme) {
        super(owner, title, modal);
        this.init(scheme);
    }

    public ConfigurationDialog(Frame owner, String title, boolean modal, ConfigurationScheme scheme) {
        super(owner, title, modal);
        this.init(scheme);
    }

    private void init(ConfigurationScheme scheme) {
        this.configurationPanel = new ConfigurationPanel(scheme);
        this.okCancelWrapperPanel = new OkCancelWrapperPanel(this.configurationPanel);
        super.setContentPane(this.okCancelWrapperPanel);
        super.pack();
        super.setLocationRelativeTo(this.getOwner());
        this.okCancelWrapperPanel.setEnabled(false);
        this.configurationPanel.addPropertyChangeListener("isDataChanged", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ConfigurationDialog.this.okCancelWrapperPanel.setEnabled(event.getNewValue().equals("1"));
            }
        });
        this.configurationPanel.setBorder(CONFIGURATION_PANEL_BORDER);
    }

    public void setReferentProperties(Properties p) {
        this.configurationPanel.setData(p);
        this.referentProperties = p;
    }

    public void hide() {
        super.hide();
        if (this.okCancelWrapperPanel.getResult() && this.referentProperties != null) {
            Properties data = this.configurationPanel.getData();
            Enumeration<?> propertyNames = data.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String oldValue;
                String name = (String)propertyNames.nextElement();
                String value = data.getProperty(name);
                if (value == null || (oldValue = this.referentProperties.getProperty(name)) != null && value.equals(oldValue)) continue;
                this.referentProperties.setProperty(name, value);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Properties q = new Properties();
        Properties qMeta = new Properties();
        qMeta.setProperty("~debug", "");
        qMeta.setProperty("~order", "file,meta-file,dummy");
        qMeta.setProperty("file", "type=file,text=Properties file");
        qMeta.setProperty("meta-file", "type=file,text=Meta properties file");
        qMeta.setProperty("dummy", "type=boolean,text=Dummy");
        ConfigurationDialog qConfigurationDialog = new ConfigurationDialog((Frame)null, "Configuration demo", true, new ConfigurationScheme(qMeta));
        qConfigurationDialog.setReferentProperties(q);
        qConfigurationDialog.show();
        Properties p = new Properties();
        Properties pMeta = new Properties();
        p.load(new FileInputStream(q.getProperty("file")));
        pMeta.load(new FileInputStream(q.getProperty("meta-file")));
        ConfigurationScheme scheme = new ConfigurationScheme(pMeta);
        ConfigurationDialog dialog = new ConfigurationDialog((Frame)null, "Configuration demo", true, scheme);
        dialog.show();
        dialog.setReferentProperties(p);
    }
}

