/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.configuration;

import com.sap.engine.library.bytecode.gui.configuration.EntryVisualizer;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.TreeCellRenderer;

final class ConfigurationCellRendererAndEditor
extends DefaultTreeCellEditor
implements TreeCellRenderer {
    private static final JLabel LABEL = new JLabel("???");
    private Color textSelectionColor;
    private Color textNonSelectionColor;
    private Color backgroundSelectionColor;
    private Color backgroundNonSelectionColor;

    ConfigurationCellRendererAndEditor(JTree tree) {
        super(tree, null);
        this.updateUI();
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("lookAndFeel")) {
                    ConfigurationCellRendererAndEditor.this.updateUI();
                }
            }
        });
    }

    private void updateUI() {
        this.textSelectionColor = UIManager.getColor("Tree.selectionForeground");
        this.textNonSelectionColor = UIManager.getColor("Tree.textForeground");
        this.backgroundSelectionColor = UIManager.getColor("Tree.selectionBackground");
        this.backgroundNonSelectionColor = UIManager.getColor("Tree.textBackground");
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        boolean bl = selected = selected || hasFocus;
        if (!(value instanceof DefaultMutableTreeNode)) {
            return LABEL;
        }
        Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
        if (userObject == null || !(userObject instanceof EntryVisualizer)) {
            return LABEL;
        }
        JComponent component = ((EntryVisualizer)userObject).getComponent();
        component.setForeground(selected ? this.textSelectionColor : this.textNonSelectionColor);
        component.setBackground(selected ? this.backgroundSelectionColor : this.backgroundNonSelectionColor);
        if (this.editingContainer != null) {
            this.editingContainer.setForeground(selected ? this.textSelectionColor : this.textNonSelectionColor);
            this.editingContainer.setBackground(selected ? this.backgroundSelectionColor : this.backgroundNonSelectionColor);
        }
        return component;
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        return this.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, true);
    }

    public boolean isCellEditable(EventObject event) {
        return true;
    }
}

