/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.common;

import com.sap.engine.library.bytecode.gui.common.AbstractInternationalizedAction;
import com.sap.engine.library.bytecode.gui.common.IconLoader;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.ResourceManager;
import com.sap.engine.library.bytecode.misc.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public final class XOptionsPane {
    private XOptionsPane() {
    }

    public static int showListDialog(Component owner, String title, Object[] options) {
        final JList<Object> list = new JList<Object>(options);
        final JDialog dialog = GUIUtils.createJDialog(owner, list, title, true);
        list.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                boolean isAction = value instanceof Action;
                Action action = null;
                if (isAction) {
                    action = (Action)value;
                    value = action.getValue("Name");
                }
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (isAction) {
                    super.setIcon((Icon)action.getValue("SmallIcon"));
                }
                return this;
            }
        });
        list.setSelectionMode(0);
        list.setSelectedIndex(0);
        final int[] result = new int[]{-1};
        list.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                int code = e.getKeyCode();
                if (code == 10) {
                    result[0] = list.getSelectedIndex();
                    dialog.hide();
                } else if (code == 27) {
                    result[0] = -1;
                    dialog.hide();
                }
            }
        });
        list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                int index = list.locationToIndex(e.getPoint());
                if (index == -1) {
                    return;
                }
                result[0] = index;
                dialog.hide();
            }
        });
        dialog.show();
        return result[0];
    }

    public static void showStacktraceDialog(Component owner, Throwable throwable) {
        JPanel contentPane = new JPanel(new BorderLayout(5, 5));
        final JTextArea textArea = new JTextArea();
        contentPane.setBorder(GUIUtils.EMPTY_BORDER_2);
        final JDialog dialog = GUIUtils.createJDialog(owner, contentPane, StringUtils.fqNameToShortName(throwable.getClass()), true);
        JLabel labelNorth = new JLabel(throwable.toString(), IconLoader.load("messages/error.gif"), 2);
        JPanel buttonsPanel = new JPanel();
        AbstractInternationalizedAction actionClose = new AbstractInternationalizedAction("CLOSE", ResourceManager.bundle){

            public void actionPerformed(ActionEvent e) {
                dialog.hide();
            }
        };
        AbstractInternationalizedAction actionCopy = new AbstractInternationalizedAction("COPY", ResourceManager.bundle){

            public void actionPerformed(ActionEvent e) {
                String text = textArea.getText();
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection selection = new StringSelection(text);
                clipboard.setContents(selection, selection);
                super.setEnabled(false);
            }
        };
        buttonsPanel.add(GUIUtils.createJButton(actionClose));
        buttonsPanel.add(GUIUtils.createJButton(actionCopy));
        contentPane.add((Component)buttonsPanel, "South");
        contentPane.add((Component)labelNorth, "North");
        textArea.setEditable(false);
        textArea.setFont(new Font("monospaced", 0, 12));
        textArea.setTabSize(2);
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(500, 250));
        contentPane.add(scrollPane);
        StringWriter writer = new StringWriter(256);
        PrintWriter writer1 = new PrintWriter(writer);
        throwable.printStackTrace(writer1);
        writer1.close();
        String s = writer.toString();
        textArea.setText(s);
        InputMap inputMap = contentPane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "CLOSE");
        inputMap.put(KeyStroke.getKeyStroke("ctrl ENTER"), "CLOSE");
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "CLOSE");
        ActionMap actionMap = contentPane.getActionMap();
        actionMap.put("CLOSE", actionClose);
        dialog.show();
    }

    public static void main(String[] args) throws Exception {
        XOptionsPane.showStacktraceDialog(null, new Exception());
    }
}

