/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.common;

import com.sap.engine.library.bytecode.gui.common.AbstractInternationalizedAction;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.ResourceManager;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public abstract class WizardPanel
extends JPanel {
    private CardLayout cardLayout;
    private JPanel panelCentre;
    private JPanel[] cards;
    private int cardIndex;
    private final Action actionPrevious = new AbstractInternationalizedAction("PREVIOUS", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            WizardPanel.this.cardLayout.previous(WizardPanel.this.panelCentre);
            WizardPanel.this.cardIndex--;
            WizardPanel.this.cardIndexChanged(WizardPanel.this.cardIndex);
            WizardPanel.this.updateButtonEnabling();
        }
    };
    private final Action actionNext = new AbstractInternationalizedAction("NEXT", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            WizardPanel.this.cardLayout.next(WizardPanel.this.panelCentre);
            WizardPanel.this.cardIndex++;
            WizardPanel.this.cardIndexChanged(WizardPanel.this.cardIndex);
            WizardPanel.this.updateButtonEnabling();
        }
    };
    private final Action actionFinish = new AbstractInternationalizedAction("FINISH", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            new Thread(this){
                private final /* synthetic */ 3 this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    3.access$300(this.this$1).wizardFinished();
                    int x = JOptionPane.showConfirmDialog(3.access$300(this.this$1), ResourceManager.get(146), "", 0, 3, null);
                    if (x == 0) {
                        System.exit(0);
                    }
                }
            }.start();
        }

        static /* synthetic */ WizardPanel access$300(3 x0) {
            return x0.WizardPanel.this;
        }
    };
    private final Action actionCancel = new AbstractInternationalizedAction("CANCEL", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            int r = JOptionPane.showConfirmDialog(WizardPanel.this, ResourceManager.get(144), "", 0, 3);
            if (r == 0) {
                System.exit(0);
            }
        }
    };

    protected WizardPanel() {
        super(new BorderLayout(5, 5));
    }

    protected final void init(JPanel[] cards, JPanel heading) {
        super.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.cardLayout = new CardLayout();
        this.panelCentre = new JPanel(this.cardLayout);
        super.add((Component)this.panelCentre, "Center");
        JPanel panelSouth = new JPanel();
        JPanel panelSouthInner = new JPanel(new GridLayout(1, 0, 5, 5));
        JButton buttonPrevious = GUIUtils.createJButton(this.actionPrevious);
        panelSouthInner.add(buttonPrevious);
        JButton buttonNext = GUIUtils.createJButton(this.actionNext);
        panelSouthInner.add(buttonNext);
        JButton buttonFinish = GUIUtils.createJButton(this.actionFinish);
        panelSouthInner.add(buttonFinish);
        JButton buttonCancel = GUIUtils.createJButton(this.actionCancel);
        panelSouthInner.add(buttonCancel);
        panelSouth.add(panelSouthInner);
        super.add((Component)panelSouth, "South");
        if (heading != null) {
            super.add((Component)heading, "North");
        }
        this.cards = cards;
        int i = 0;
        while (i < cards.length) {
            this.panelCentre.add((Component)cards[i], "P" + i);
            ++i;
        }
        this.cardIndex = 0;
        this.updateButtonEnabling();
    }

    protected boolean canGoToPrevious(int currentCardIndex) {
        return true;
    }

    protected boolean canGoToNext(int currentCardIndex) {
        return true;
    }

    protected abstract void cardIndexChanged(int var1);

    protected boolean canFinish() {
        return true;
    }

    protected abstract void wizardFinished();

    protected final void updateButtonEnabling() {
        this.actionPrevious.setEnabled(this.cardIndex > 0 && this.canGoToPrevious(this.cardIndex));
        this.actionNext.setEnabled(this.cardIndex < this.cards.length - 1 && this.canGoToNext(this.cardIndex));
        this.actionFinish.setEnabled(this.cardIndex == this.cards.length - 1 && this.canFinish());
    }
}

