/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.common;

import com.sap.engine.library.bytecode.gui.common.IconLoader;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public abstract class AbstractInternationalizedAction
extends AbstractAction {
    private static final String IS_ENABLED_PROPERTY = "enabled";
    private boolean isEnabled = true;
    private static final String ACTION_PREFIX = "ACTION_";
    private static final String NAME_SUFFIX = "_NAME";
    private static final String ICON_SUFFIX = "_ICON";
    private static final String DESCRIPTION_SUFFIX = "_DESCRIPTION";
    private static final String ACCELERATOR_SUFFIX = "_ACCELERATOR";

    public AbstractInternationalizedAction(String identifier, ResourceBundle bundle) {
        String icon;
        KeyStroke keyStroke;
        String accelerator;
        String description;
        String name = bundle.getString(ACTION_PREFIX + identifier + NAME_SUFFIX);
        if (name.length() != 0) {
            int indexOfAmpersand = name.indexOf(38);
            if (indexOfAmpersand != -1 && indexOfAmpersand != name.length() - 1) {
                char mnemonic = name.charAt(indexOfAmpersand + 1);
                super.putValue("MnemonicKey", new Integer(mnemonic));
                name = name.substring(0, indexOfAmpersand) + name.substring(indexOfAmpersand + 1);
            }
            super.putValue("Name", name);
        }
        if ((description = bundle.getString(ACTION_PREFIX + identifier + DESCRIPTION_SUFFIX)).length() != 0) {
            super.putValue("ShortDescription", description);
        }
        if ((accelerator = bundle.getString(ACTION_PREFIX + identifier + ACCELERATOR_SUFFIX)).length() != 0 && (keyStroke = KeyStroke.getKeyStroke(accelerator)) != null) {
            super.putValue("AcceleratorKey", keyStroke);
        }
        if ((icon = bundle.getString(ACTION_PREFIX + identifier + ICON_SUFFIX)).length() != 0) {
            super.putValue("SmallIcon", IconLoader.load(icon));
        }
    }

    public final void setEnabled(boolean b) {
        if (this.isEnabled == b) {
            return;
        }
        this.isEnabled = b;
        if (b) {
            super.firePropertyChange(IS_ENABLED_PROPERTY, Boolean.FALSE, Boolean.TRUE);
        } else {
            super.firePropertyChange(IS_ENABLED_PROPERTY, Boolean.TRUE, Boolean.FALSE);
        }
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }
}

