/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.cfviewer;

import com.sap.engine.library.bytecode.cf.CFNode;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;

final class IconedTreeNode
extends DefaultMutableTreeNode {
    private final Icon icon;
    private final byte[] data;
    private final int start;
    private final int end;
    private String description;

    IconedTreeNode(String userObject, Icon icon, String description) {
        super(userObject);
        this.icon = icon;
        this.data = null;
        this.start = -1;
        this.end = -1;
        this.description = description;
    }

    IconedTreeNode(String userObject, Icon icon, byte[] data, String description) {
        super(userObject);
        this.icon = icon;
        this.data = data;
        if (data == null) {
            this.start = -1;
            this.end = -1;
        } else {
            this.start = 0;
            this.end = data.length;
        }
        this.description = description;
    }

    IconedTreeNode(String userObject, Icon icon, CFNode node, String description) {
        super(userObject);
        this.icon = icon;
        this.data = null;
        if (node == null) {
            this.start = -1;
            this.end = -1;
        } else {
            this.start = node.getOffsetStart();
            this.end = node.getOffsetEnd();
        }
        this.description = description;
    }

    IconedTreeNode(String userObject, Icon icon, CFNode node, int deltaStart, int deltaEnd, String description) {
        super(userObject);
        this.icon = icon;
        this.data = null;
        if (node == null || node.getOffsetStart() == -1) {
            this.start = -1;
            this.end = -1;
        } else {
            this.start = node.getOffsetStart() + deltaStart;
            this.end = node.getOffsetStart() + deltaEnd;
        }
        this.description = description;
    }

    Icon getIcon() {
        return this.icon;
    }

    byte[] getData() {
        return this.data;
    }

    int getStart() {
        return this.start;
    }

    int getEnd() {
        return this.end;
    }

    void setDescription(String description) {
        this.description = description;
    }

    String getDescription() {
        return this.description;
    }
}

