/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.cfviewer;

import com.sap.engine.library.bytecode.cf.AttributeInfo;
import com.sap.engine.library.bytecode.cf.Attributed;
import com.sap.engine.library.bytecode.cf.CFFactory;
import com.sap.engine.library.bytecode.cf.CFNode;
import com.sap.engine.library.bytecode.cf.CFParser;
import com.sap.engine.library.bytecode.cf.CPInfo;
import com.sap.engine.library.bytecode.cf.ClassFile;
import com.sap.engine.library.bytecode.cf.CodeAttribute;
import com.sap.engine.library.bytecode.cf.ConstantValueAttribute;
import com.sap.engine.library.bytecode.cf.Constants;
import com.sap.engine.library.bytecode.cf.ExceptionHandler;
import com.sap.engine.library.bytecode.cf.ExceptionsAttribute;
import com.sap.engine.library.bytecode.cf.FieldInfo;
import com.sap.engine.library.bytecode.cf.InnerClassesAttribute;
import com.sap.engine.library.bytecode.cf.InnerClassesAttributeEntry;
import com.sap.engine.library.bytecode.cf.Instruction;
import com.sap.engine.library.bytecode.cf.LineNumberTableAttribute;
import com.sap.engine.library.bytecode.cf.LocalVariableTableAttribute;
import com.sap.engine.library.bytecode.cf.LocalVariableTableEntry;
import com.sap.engine.library.bytecode.cf.MethodInfo;
import com.sap.engine.library.bytecode.cf.SourceFileAttribute;
import com.sap.engine.library.bytecode.gui.cfviewer.IconedTreeCellRenderer;
import com.sap.engine.library.bytecode.gui.cfviewer.IconedTreeNode;
import com.sap.engine.library.bytecode.gui.common.IconLoader;
import com.sap.engine.library.bytecode.gui.common.SmartTreeExpansionListener;
import com.sap.engine.library.bytecode.gui.hex.HexPanel;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class CFViewerPanel
extends JPanel {
    private static final Icon ICON_CLASS = IconLoader.load("oo/class.gif");
    private static final Icon ICON_INTERFACE = IconLoader.load("oo/interface.gif");
    private static final Icon ICON_FIELD = IconLoader.load("oo/field.gif");
    private static final Icon ICON_METHOD = IconLoader.load("oo/method.gif");
    private static final Icon ICON_PRIMITIVE = IconLoader.load("oo/primitive.gif");
    private static final int SPLIT_PANE_DIVIDER_SIZE = 5;
    private final DefaultMutableTreeNode rootNode;
    private final DefaultTreeModel model;
    private final JTree tree;
    private final HexPanel hexPanel;
    private byte[] currentSelectedByteArray;
    private final Map mapClassnameToNode = new Hashtable();
    private final JEditorPane editorPane;
    static /* synthetic */ Class class$com$sap$engine$library$bytecode$gui$cfviewer$CFViewerPanel;

    public CFViewerPanel() {
        super(new BorderLayout());
        this.rootNode = new DefaultMutableTreeNode();
        this.model = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.model);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new IconedTreeCellRenderer());
        this.tree.addTreeExpansionListener(new SmartTreeExpansionListener(this.tree));
        this.hexPanel = new HexPanel();
        this.editorPane = new JEditorPane();
        this.editorPane.setContentType("text/html");
        this.editorPane.setEditable(false);
        JScrollPane scrollPaneTree = new JScrollPane(this.tree);
        JScrollPane scrollPaneEditor = new JScrollPane(this.editorPane);
        scrollPaneTree.setMinimumSize(new Dimension(60, 60));
        scrollPaneTree.setPreferredSize(new Dimension(60, 60));
        scrollPaneEditor.setMinimumSize(new Dimension(40, 40));
        scrollPaneEditor.setPreferredSize(new Dimension(40, 40));
        JSplitPane splitPaneLeft = new JSplitPane(0, scrollPaneTree, scrollPaneEditor);
        splitPaneLeft.setResizeWeight(1.0);
        splitPaneLeft.setDividerSize(5);
        JSplitPane splitPane = new JSplitPane(1, splitPaneLeft, this.hexPanel);
        splitPane.setDividerSize(5);
        splitPane.setResizeWeight(1.0);
        super.add((Component)splitPane, "Center");
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                CFViewerPanel.this.updateTableFromTree();
            }
        });
        this.hexPanel.addTableMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                CFViewerPanel.this.updateTreeFromTable(e.getClickCount());
            }
        });
        this.hexPanel.addTableKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    CFViewerPanel.this.updateTreeFromTable(1);
                }
            }
        });
    }

    private void updateTableFromTree() {
        TreeNode parent;
        byte[] data;
        IconedTreeNode node;
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            this.hexPanel.setSelectionInterval(-1, -1);
            this.editorPane.setText("");
            return;
        }
        Object lastPathComponent = path.getLastPathComponent();
        if (!(lastPathComponent instanceof IconedTreeNode)) {
            this.hexPanel.setSelectionInterval(-1, -1);
            this.editorPane.setText("");
            return;
        }
        IconedTreeNode x = node = (IconedTreeNode)lastPathComponent;
        while ((data = x.getData()) == null && (parent = x.getParent()) != null && parent instanceof IconedTreeNode) {
            x = (IconedTreeNode)parent;
        }
        if (data == null) {
            this.hexPanel.setSelectionInterval(-1, -1);
            return;
        }
        if (this.currentSelectedByteArray != data) {
            this.hexPanel.setData(data);
            this.currentSelectedByteArray = data;
        }
        int start = node.getStart();
        int end = node.getEnd();
        this.hexPanel.setSelectionInterval(start, end);
        String description = node.getDescription();
        this.editorPane.setText(description == null ? "" : description);
    }

    private void updateTreeFromTable(int clickCount) {
        TreeNode parent;
        int index = this.hexPanel.getFocusedIndex();
        if (index == -1) {
            return;
        }
        IconedTreeNode node = this.findDeepestNodeByOffset(index);
        if (node == null) {
            return;
        }
        while (--clickCount != 0 && (parent = node.getParent()) != null && parent instanceof IconedTreeNode) {
            node = (IconedTreeNode)parent;
        }
        TreePath path = GUIUtils.nodeToPath(node);
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
    }

    private IconedTreeNode findDeepestNodeByOffset(int index) {
        IconedTreeNode classRootNode;
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        if (path.getPathCount() < 2) {
            return null;
        }
        Object classRoot = path.getPathComponent(1);
        if (classRoot == null || !(classRoot instanceof IconedTreeNode)) {
            return null;
        }
        IconedTreeNode r = classRootNode = (IconedTreeNode)classRoot;
        block0: while (true) {
            int nChildren = r.getChildCount();
            int i = 0;
            while (i < nChildren) {
                TreeNode child = r.getChildAt(i);
                if (child instanceof IconedTreeNode) {
                    IconedTreeNode childNode = (IconedTreeNode)child;
                    int start = childNode.getStart();
                    int end = childNode.getEnd();
                    if (start != -1 && end != -1 && start <= index && index < end) {
                        r = childNode;
                        continue block0;
                    }
                }
                ++i;
            }
            break;
        }
        return r;
    }

    public void addData(String filename) throws IOException {
        CFFactory factory = CFFactory.getThreadLocalInstance();
        CFParser parser = factory.createCFParser();
        this.addData(parser.parse(filename, null));
    }

    public void addData(byte[] bytecodes) throws IOException {
        CFFactory factory = CFFactory.getThreadLocalInstance();
        CFParser parser = factory.createCFParser();
        this.addData(parser.parse(bytecodes, null));
    }

    public void addData(ClassFile cf) {
        String s;
        String className = cf.getName();
        IconedTreeNode node = (IconedTreeNode)this.mapClassnameToNode.get(className);
        if (node != null) {
            this.model.removeNodeFromParent(node);
        }
        boolean isInterface = cf.isInterface();
        IconedTreeNode x = new IconedTreeNode((isInterface ? "interface " : "class ") + className, isInterface ? ICON_INTERFACE : ICON_CLASS, cf.getOriginalBytecode(), null);
        int ncp = cf.getCPSize();
        int cpStartOffset = 8;
        int cpEndOffset = cf.getCPInfo(ncp - 1).getOffsetEnd();
        int nInterfaces = cf.getNInterfaces();
        int interfacesOffsetStart = cpEndOffset + 6;
        int interfacesOffsetEnd = interfacesOffsetStart + 2 + nInterfaces * 2;
        IconedTreeNode y = new IconedTreeNode("Header", null, cf, 0, interfacesOffsetEnd, null);
        x.add(y);
        y.setDescription("Contains information about the name of the class and its super class, implemented interfaces and access flags; contains also the 'constant pool'.");
        y.add(new IconedTreeNode("Magic number: 0x" + StringUtils.toHexString(-889275714L, 8), null, cf, 0, 4, null));
        y.add(new IconedTreeNode("Minor version: " + cf.getMinorVersion(), null, cf, 4, 6, null));
        int majorVersion = cf.getMajorVersion();
        switch (majorVersion) {
            case 45: {
                s = "JDK 1.3";
                break;
            }
            case 46: {
                s = "JDK 1.4";
                break;
            }
            default: {
                s = "Unknown JDK";
            }
        }
        y.add(new IconedTreeNode("Major version: " + majorVersion + " (" + s + ")", null, cf, 6, 8, null));
        IconedTreeNode z = new IconedTreeNode("Constant pool (" + ncp + ")", null, cf, cpStartOffset, cpEndOffset, null);
        y.add(z);
        z.setDescription("A symbol table for strings and symbolic references to classes, methods and fields. Usually this is the biggest part of a classfile.");
        IconedTreeNode t = new IconedTreeNode("Number of entries: " + ncp, null, cf, cpStartOffset, cpStartOffset + 2, null);
        z.add(t);
        t.setDescription("Peculiarities: There is an implicit 0-th entry; 'long' and 'double' constants are counted as two entries.");
        int i = 0;
        while (i < ncp) {
            CPInfo cpInfo = cf.getCPInfo(i);
            int tag = cpInfo.getTag();
            t = new IconedTreeNode("[" + i + "] " + cpInfo, null, cpInfo, null);
            z.add(t);
            if (tag == 0) {
                t.setDescription("This entry does not exist physically in the classfile.");
            } else {
                t.add(new IconedTreeNode("Tag: " + tag + " (" + Constants.CONSTANT_MNEMONICS[tag] + ")", null, cpInfo, 0, 1, null));
                switch (tag) {
                    case 7: {
                        t.setDescription("A symbolic reference to a class.");
                        CPInfo name = cpInfo.getValueName();
                        t.add(new IconedTreeNode("Name index: [" + name.getIndex() + "], " + name, null, cpInfo, 1, 3, null));
                        break;
                    }
                    case 1: {
                        t.setDescription("A unicode sequence of characters in utf-8 encoding with a 2-byte length header. Is not null-terminated. Note the difference: CONSTANT_String is an object but CONSTANT_Utf8 is only a sequence of characters which can be referenced from other entries or from structures deeper in the classfile.");
                        t.add(new IconedTreeNode("Length", null, cpInfo, 1, 3, null));
                        t.add(new IconedTreeNode("Bytes: \"" + StringUtils.escapeString(cpInfo.getString()) + "\"", null, cpInfo, 3, cpInfo.getOffsetEnd() - cpInfo.getOffsetStart(), null));
                        break;
                    }
                    case 3: 
                    case 4: {
                        t.add(new IconedTreeNode("Bytes: 0x" + StringUtils.toHexString(cpInfo.getValueInt(), 4), null, cpInfo, 1, 5, null));
                        break;
                    }
                    case 5: 
                    case 6: {
                        t.setDescription("CONSTANT_Long and CONSTANT_Double constants occupy two entries instead of one.");
                        long l = cpInfo.getValueLong();
                        int high = (int)(l >>> 4);
                        int low = (int)l;
                        t.add(new IconedTreeNode("High bytes: 0x" + StringUtils.toHexString(high, 4), null, cpInfo, 1, 5, null));
                        t.add(new IconedTreeNode("Low bytes:  0x" + StringUtils.toHexString(low, 4), null, cpInfo, 5, 9, null));
                        break;
                    }
                    case 8: {
                        t.setDescription("Represents a java/lang/String object. Note the difference: CONSTANT_String is an object but CONSTANT_Utf8 is only a sequence of characters which can be referenced from other entries or from structures deeper in the classfile.");
                        CPInfo value = cpInfo.getValueString();
                        t.add(new IconedTreeNode("Value index: [" + value.getIndex() + "], " + value, null, cpInfo, 1, 3, null));
                        break;
                    }
                    case 12: {
                        t.setDescription("A pair of a name and descriptor for a member of a class.");
                        CPInfo name = cpInfo.getValueName();
                        CPInfo descriptor = cpInfo.getValueDescriptor();
                        t.add(new IconedTreeNode("Name index: [" + name.getIndex() + "], " + name, null, cpInfo, 1, 3, null));
                        t.add(new IconedTreeNode("Descriptor index: [" + descriptor.getIndex() + "], " + descriptor, null, cpInfo, 3, 5, null));
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        t.setDescription("A symbolic reference to a class member.");
                        CPInfo aClass = cpInfo.getValueClass();
                        CPInfo nameAndType = cpInfo.getValueNameAndType();
                        t.add(new IconedTreeNode("Class index: [" + aClass.getIndex() + "], " + aClass, null, cpInfo, 1, 3, null));
                        t.add(new IconedTreeNode("Name and type index: [" + nameAndType.getIndex() + "], " + nameAndType, null, cpInfo, 3, 5, null));
                        break;
                    }
                    default: {
                        t.add(new IconedTreeNode("// Unrecognized", null, null));
                    }
                }
            }
            switch (tag) {
                default: 
            }
            ++i;
        }
        CFViewerPanel.addNodeForAccessFlags(cf.getAccessFlags(), y, cf, cpEndOffset, cpEndOffset + 2, true);
        y.add(new IconedTreeNode("This class: " + cf.getThisClass(), null, cf, cpEndOffset + 2, cpEndOffset + 4, null));
        z = new IconedTreeNode("Super class: " + cf.getSuperClass(), null, cf, cpEndOffset + 4, cpEndOffset + 6, null);
        y.add(z);
        z.setDescription("Every class must have a superclass, except java/lang/Object.");
        z = new IconedTreeNode("Interfaces (" + nInterfaces + ")", null, cf, interfacesOffsetStart, interfacesOffsetEnd, null);
        y.add(z);
        z.add(new IconedTreeNode("Number of interfaces: " + nInterfaces, null, cf, interfacesOffsetStart, interfacesOffsetStart + 2, null));
        int i2 = 0;
        while (i2 < nInterfaces) {
            z.add(new IconedTreeNode(cf.getInterface(i2).toString(), null, cf, interfacesOffsetStart + 2 + i2 * 2, interfacesOffsetStart + 2 + i2 * 2 + 2, null));
            ++i2;
        }
        FieldInfo[] fields = cf.getFieldsArray();
        int nFields = fields.length;
        int fieldsOffsetStart = nFields == 0 ? interfacesOffsetEnd : fields[0].getOffsetStart() - 2;
        int fieldsOffsetEnd = nFields == 0 ? interfacesOffsetEnd + 2 : fields[nFields - 1].getOffsetEnd();
        y = new IconedTreeNode("Fields (" + nFields + ")", null, cf, fieldsOffsetStart, fieldsOffsetEnd, null);
        x.add(y);
        y.add(new IconedTreeNode("Number of fields: " + nFields, null, cf, fieldsOffsetStart, fieldsOffsetStart + 2, null));
        int i3 = 0;
        while (i3 < nFields) {
            FieldInfo f = fields[i3];
            z = new IconedTreeNode(f.getName() + ' ' + f.getDescriptor(), ICON_FIELD, f, null);
            y.add(z);
            CFViewerPanel.addNodeForAccessFlags(f.getAccessFlags(), z, f, 0, 2, false);
            z.add(new IconedTreeNode("Name: " + f.getNameCPInfo(), null, f, 2, 4, null));
            z.add(new IconedTreeNode("Descriptor: " + f.getDescriptorCPInfo(), null, f, 4, 6, null));
            this.addNodesForAttributes(f, z, f, 6, f.getOffsetEnd() - f.getOffsetStart());
            ++i3;
        }
        MethodInfo[] methods = cf.getMethodsArray();
        int nMethods = methods.length;
        int methodsOffsetStart = nMethods == 0 ? fieldsOffsetEnd : methods[0].getOffsetStart() - 2;
        int methodsOffsetEnd = nMethods == 0 ? fieldsOffsetEnd + 2 : methods[nMethods - 1].getOffsetEnd();
        y = new IconedTreeNode("Methods (" + nMethods + ")", null, cf, methodsOffsetStart, methodsOffsetEnd, null);
        x.add(y);
        y.add(new IconedTreeNode("Number of methods: " + nMethods, null, cf, methodsOffsetStart, methodsOffsetStart + 2, null));
        int i4 = 0;
        while (i4 < nMethods) {
            MethodInfo m = methods[i4];
            z = new IconedTreeNode(m.getName() + m.getDescriptor(), ICON_METHOD, m, null);
            y.add(z);
            CFViewerPanel.addNodeForAccessFlags(m.getAccessFlags(), z, m, 0, 2, false);
            z.add(new IconedTreeNode("Name: " + m.getNameCPInfo(), null, m, 2, 4, null));
            z.add(new IconedTreeNode("Descriptor: " + m.getDescriptorCPInfo(), null, m, 4, 6, null));
            this.addNodesForAttributes(m, z, m, 6, m.getOffsetEnd() - m.getOffsetStart());
            ++i4;
        }
        this.addNodesForAttributes(cf, x, cf, methodsOffsetEnd, cf.getOffsetEnd());
        this.rootNode.add(x);
        this.model.nodeStructureChanged(this.rootNode);
        TreePath path = new TreePath(new Object[]{this.rootNode, x});
        this.tree.expandPath(path);
        this.tree.setSelectionPath(path);
        this.mapClassnameToNode.put(className, x);
    }

    private void addNodesForAttributes(Attributed attributed, IconedTreeNode x, CFNode node, int deltaStart, int deltaEnd) {
        int nAttributes = attributed.getNAttributes();
        IconedTreeNode y = new IconedTreeNode("Attributes (" + nAttributes + ")", null, node, deltaStart, deltaEnd, null);
        x.add(y);
        y.setDescription("Some of the structures in the classfile are allowed to contain other strucures as attributes. There are several pre-defined attributes which are recognized by the vm, compiler vendors may specify their own attributes.");
        y.add(new IconedTreeNode("Number of attributes: " + nAttributes, null, node, deltaStart, deltaStart + 2, null));
        int i = 0;
        while (i < nAttributes) {
            int j;
            CFNode[] entries;
            IconedTreeNode t;
            AttributeInfo attribute = attributed.getAttribute(i);
            IconedTreeNode z = new IconedTreeNode(attribute.getName() + " attribute", null, attribute, null);
            y.add(z);
            z.add(new IconedTreeNode("Attribute name: \"" + attribute.getName() + "\"", null, attribute, 0, 2, null));
            z.add(new IconedTreeNode("Attribute length: " + (attribute.getOffsetEnd() - attribute.getOffsetStart() - 6), null, attribute, 2, 6, null));
            if (attribute instanceof CodeAttribute) {
                z.setDescription("Contains the instructions and exception handlers for a method. The Code attribute can have its own attributes - LineNumberTable and LocalVariableTable.");
                CodeAttribute codeAttribute = (CodeAttribute)attribute;
                t = new IconedTreeNode("Max stack: " + codeAttribute.getOriginalMaxStack(), null, codeAttribute, 6, 8, null);
                z.add(t);
                t.setDescription("A limitation for the number of words on the stack that the method can use. Set by the compiler, checked by the verifier.");
                t = new IconedTreeNode("Max locals: " + codeAttribute.getOriginalMaxLocals(), null, codeAttribute, 8, 10, null);
                z.add(t);
                t.setDescription("A limitation for the number of local variable slots that the method can use. Set by the compiler, checked by the verifier.");
                Instruction[] instructions = codeAttribute.getInstructionsArray();
                int instructionsDeltaOffsetStart = instructions[0].getOffsetStart() - codeAttribute.getOffsetStart();
                int instructionsDeltaOffsetEnd = instructions[instructions.length - 1].getOffsetEnd() - codeAttribute.getOffsetStart();
                t = new IconedTreeNode("Instructions (" + instructions.length + ")", null, codeAttribute, 10, instructionsDeltaOffsetEnd - instructionsDeltaOffsetStart + 14, null);
                z.add(t);
                IconedTreeNode u = new IconedTreeNode("Code length: " + (instructionsDeltaOffsetEnd - instructionsDeltaOffsetStart), null, codeAttribute, 10, 14, null);
                t.add(u);
                u.setDescription("Length of the instructions, in bytes.");
                int j2 = 0;
                while (j2 < instructions.length) {
                    t.add(new IconedTreeNode(instructions[j2].getOriginalOffset() + ": " + instructions[j2], ICON_PRIMITIVE, instructions[j2], null));
                    ++j2;
                }
                ExceptionHandler[] handlers = codeAttribute.getExceptionHandlersArray();
                int handlersDeltaOffsetStart = instructionsDeltaOffsetEnd;
                int handlersDeltaOffsetEnd = handlersDeltaOffsetStart + 2 + 8 * handlers.length;
                t = new IconedTreeNode("Exception handlers (" + handlers.length + ")", null, codeAttribute, handlersDeltaOffsetStart, handlersDeltaOffsetEnd, "Exception handlers correspond to JLS catch statements.");
                z.add(t);
                t.add(new IconedTreeNode("Number of handlers: " + handlers.length, null, codeAttribute, handlersDeltaOffsetStart, handlersDeltaOffsetStart + 2, null));
                int j3 = 0;
                while (j3 < handlers.length) {
                    int handlerOffsetStart = handlersDeltaOffsetStart + 2 + 8 * j3;
                    u = new IconedTreeNode(handlers[j3].toString(), null, codeAttribute, handlerOffsetStart, handlerOffsetStart + 8, null);
                    t.add(u);
                    u.add(new IconedTreeNode("Start PC: " + handlers[j3].getStartPC(), ICON_PRIMITIVE, codeAttribute, handlerOffsetStart, handlerOffsetStart + 2, null));
                    IconedTreeNode v = new IconedTreeNode("End PC: " + handlers[j3].getEndPCInclusive(), ICON_PRIMITIVE, codeAttribute, handlerOffsetStart + 2, handlerOffsetStart + 4, null);
                    u.add(v);
                    v.setDescription("End PC indices for exception handlers are inclusive.");
                    u.add(new IconedTreeNode("Handler PC: " + handlers[j3].getHandlerPC(), ICON_PRIMITIVE, codeAttribute, handlerOffsetStart + 4, handlerOffsetStart + 6, null));
                    u.add(new IconedTreeNode("Catch type: " + handlers[j3].getCatchType(), null, codeAttribute, handlerOffsetStart + 6, handlerOffsetStart + 8, null));
                    ++j3;
                }
                this.addNodesForAttributes(codeAttribute, z, codeAttribute, handlersDeltaOffsetEnd, codeAttribute.getOffsetEnd() - codeAttribute.getOffsetStart());
            } else if (attribute instanceof SourceFileAttribute) {
                SourceFileAttribute sourceFileAttribute = (SourceFileAttribute)attribute;
                z.setDescription("An optional attribute. The name of the source file from which this classfile was compiled. Used by debuggers and by the vm to build stack traces.");
                z.add(new IconedTreeNode("Source file: " + sourceFileAttribute.getSourceFile(), null, sourceFileAttribute, 6, 8, null));
            } else if (attribute instanceof ConstantValueAttribute) {
                ConstantValueAttribute constantValueAttribute = (ConstantValueAttribute)attribute;
                z.add(new IconedTreeNode("Constant value: " + constantValueAttribute.getConstantValue(), null, constantValueAttribute, 6, 8, null));
            } else if (attribute instanceof LineNumberTableAttribute) {
                z.setDescription("An optional attribute. Contains an instruction to line number mapping for this method. Set by the compiler, used by debuggers and by the vm to construct stack traces.");
                LineNumberTableAttribute lineNumberTableAttribute = (LineNumberTableAttribute)attribute;
                int[] lineNumbers = lineNumberTableAttribute.getLineNumbersArray();
                Instruction[] startPCs = lineNumberTableAttribute.getStartPCsArray();
                z.add(new IconedTreeNode("Number of entries: " + lineNumbers.length, null, lineNumberTableAttribute, 6, 8, null));
                int j4 = 0;
                while (j4 < lineNumbers.length) {
                    t = new IconedTreeNode(lineNumbers[j4] + " -> " + startPCs[j4], null, lineNumberTableAttribute, 8 + 4 * j4, 8 + 4 * j4 + 4, null);
                    z.add(t);
                    t.add(new IconedTreeNode("Start PC: " + startPCs[j4], ICON_PRIMITIVE, lineNumberTableAttribute, 8 + 4 * j4, 8 + 4 * j4 + 2, null));
                    t.add(new IconedTreeNode("Line number: " + lineNumbers[j4], null, lineNumberTableAttribute, 8 + 4 * j4 + 2, 8 + 4 * j4 + 4, null));
                    ++j4;
                }
            } else if (attribute instanceof LocalVariableTableAttribute) {
                z.setDescription("An optional attribute. Contains a mapping from instructions and local variable indices to variable names and descriptors. Set by the compiler, used by debuggers.");
                LocalVariableTableAttribute localVariableTableAttribute = (LocalVariableTableAttribute)attribute;
                entries = localVariableTableAttribute.getEntriesArray();
                z.add(new IconedTreeNode("Number of entries: " + entries.length, null, localVariableTableAttribute, 6, 8, null));
                j = 0;
                while (j < entries.length) {
                    CFNode entry = entries[j];
                    t = new IconedTreeNode(((LocalVariableTableEntry)entry).getName().toPlainString() + ' ' + ((LocalVariableTableEntry)entry).getDescriptor().toPlainString() + " (var " + ((LocalVariableTableEntry)entry).getLocalVariable().getIndex() + ")", null, entry, null);
                    z.add(t);
                    t.add(new IconedTreeNode("Local variable: " + ((LocalVariableTableEntry)entry).getLocalVariable(), null, entry, 0, 2, null));
                    t.add(new IconedTreeNode("Name: " + ((LocalVariableTableEntry)entry).getName(), null, entry, 2, 4, null));
                    t.add(new IconedTreeNode("Descriptor: " + ((LocalVariableTableEntry)entry).getDescriptor(), null, entry, 4, 6, null));
                    t.add(new IconedTreeNode("Start PC: " + ((LocalVariableTableEntry)entry).getStartPC(), ICON_PRIMITIVE, entry, 6, 8, null));
                    t.add(new IconedTreeNode("End PC: " + ((LocalVariableTableEntry)entry).getEndPC(), ICON_PRIMITIVE, entry, 8, 10, null));
                    ++j;
                }
            } else if (attribute instanceof InnerClassesAttribute) {
                z.setDescription("An optional attribute. This attribute is not part of the vm spec, but of the inner classes spec. Does not affect vm execution.");
                InnerClassesAttribute innerClassesAttribute = (InnerClassesAttribute)attribute;
                entries = innerClassesAttribute.getEntries();
                z.add(new IconedTreeNode("Number of entries: " + entries.length, null, innerClassesAttribute, 6, 8, null));
                j = 0;
                while (j < entries.length) {
                    CFNode entry = entries[j];
                    CPInfo innerName = ((InnerClassesAttributeEntry)entry).getInnerNameCPInfo();
                    t = new IconedTreeNode("Entry: " + (innerName.getTag() == 0 ? "(Anonymous)" : innerName.toPlainString()), null, entry, null);
                    z.add(t);
                    t.add(new IconedTreeNode("Inner name: " + innerName, null, entry, 0, 2, null));
                    t.add(new IconedTreeNode("Inner class: " + ((InnerClassesAttributeEntry)entry).getInnerClass(), null, entry, 2, 4, null));
                    t.add(new IconedTreeNode("Outer class: " + ((InnerClassesAttributeEntry)entry).getOuterClass(), null, entry, 4, 6, null));
                    CFViewerPanel.addNodeForAccessFlags(((InnerClassesAttributeEntry)entry).getInnerAccessFlags(), t, entry, 6, 8, false);
                    ++j;
                }
            } else if (attribute instanceof ExceptionsAttribute) {
                z.setDescription("An optional attribute. Indicates the exceptions that the method has declared in its JLS 'throws' clause. Surprisingly or not, stripping this attribute out of the classfile does not affect the vm, neither the verifier.");
                ExceptionsAttribute exceptionsAttribute = (ExceptionsAttribute)attribute;
                CPInfo[] exceptions = exceptionsAttribute.getExceptionsArray();
                z.add(new IconedTreeNode("Number of entries: " + exceptions.length, null, exceptionsAttribute, 6, 8, null));
                j = 0;
                while (j < exceptions.length) {
                    z.add(new IconedTreeNode(exceptions[j].toString(), null, exceptionsAttribute, 8 + j * 2, 8 + j * 2 + 2, null));
                    ++j;
                }
            }
            ++i;
        }
    }

    private static void addNodeForAccessFlags(int accessFlags, IconedTreeNode x, CFNode node, int deltaStart, int deltaEnd, boolean isClass) {
        StringBuffer buffer = new StringBuffer();
        boolean isFirst = true;
        int i = 0;
        while (i < Constants.ACCESS_FLAG_MNEMONICS.length) {
            if ((accessFlags & 1 << i) != 0) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buffer.append(' ');
                }
                if (i == 32 && isClass) {
                    buffer.append("'super'");
                } else {
                    buffer.append(Constants.ACCESS_FLAG_MNEMONICS[i]);
                }
            }
            ++i;
        }
        x.add(new IconedTreeNode("Access flags: 0x" + StringUtils.toHexString(accessFlags, 4) + " (" + buffer + ")", null, node, deltaStart, deltaEnd, null));
    }

    public static void main(String[] args) throws Exception {
        CFFactory factory = CFFactory.getThreadLocalInstance();
        CFParser parser = factory.createCFParser();
        FileInputStream in = args.length > 0 ? new FileInputStream(args[0]) : (class$com$sap$engine$library$bytecode$gui$cfviewer$CFViewerPanel == null ? (class$com$sap$engine$library$bytecode$gui$cfviewer$CFViewerPanel = CFViewerPanel.class$("com.sap.engine.library.bytecode.gui.cfviewer.CFViewerPanel")) : class$com$sap$engine$library$bytecode$gui$cfviewer$CFViewerPanel).getClassLoader().getResourceAsStream((class$com$sap$engine$library$bytecode$gui$cfviewer$CFViewerPanel == null ? (class$com$sap$engine$library$bytecode$gui$cfviewer$CFViewerPanel = CFViewerPanel.class$("com.sap.engine.library.bytecode.gui.cfviewer.CFViewerPanel")) : class$com$sap$engine$library$bytecode$gui$cfviewer$CFViewerPanel).getName().replace('.', '/') + ".class");
        ClassFile cf = parser.parse(in, null);
        CFViewerPanel panel = new CFViewerPanel();
        panel.addData(cf);
        GUIUtils.showInAFrame(panel);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

