/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.gui.browser;

import com.sap.engine.library.bytecode.gui.common.AbstractInternationalizedAction;
import com.sap.engine.library.bytecode.gui.common.XOptionsPane;
import com.sap.engine.library.bytecode.misc.GUIUtils;
import com.sap.engine.library.bytecode.misc.ResourceManager;
import com.sap.engine.library.bytecode.misc.ThreadUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public final class HTMLBrowserPanel
extends JPanel {
    private final JTextField tfAddress;
    private final JEditorPane editorPane;
    private final Vector history = new Vector();
    private int historyIndex = -1;
    private final Action actionBack = new AbstractInternationalizedAction("BACK", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            if (HTMLBrowserPanel.this.historyIndex == 0) {
                return;
            }
            HTMLBrowserPanel.this.historyIndex--;
            HTMLBrowserPanel.this.updateActionEnabling();
            HTMLBrowserPanel.this.setPageInternal((String)HTMLBrowserPanel.this.history.get(HTMLBrowserPanel.this.historyIndex));
        }
    };
    private final Action actionForward = new AbstractInternationalizedAction("FORWARD", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            if (HTMLBrowserPanel.this.historyIndex >= HTMLBrowserPanel.this.history.size() - 1) {
                return;
            }
            HTMLBrowserPanel.this.historyIndex++;
            HTMLBrowserPanel.this.updateActionEnabling();
            HTMLBrowserPanel.this.setPageInternal((String)HTMLBrowserPanel.this.history.get(HTMLBrowserPanel.this.historyIndex));
        }
    };
    private final Action actionGo = new AbstractInternationalizedAction("GO", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            ThreadUtils.fork(new Runnable(this){
                private final /* synthetic */ 3 this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    3.access$400(this.this$1).setPage(HTMLBrowserPanel.access$500(3.access$400(this.this$1)).getText());
                }
            });
        }

        static /* synthetic */ HTMLBrowserPanel access$400(3 x0) {
            return x0.HTMLBrowserPanel.this;
        }
    };
    private final Action actionShowHistory = new AbstractInternationalizedAction("HISTORY", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            Object[] urls = HTMLBrowserPanel.this.history.toArray(new String[HTMLBrowserPanel.this.history.size()]);
            int x = XOptionsPane.showListDialog(HTMLBrowserPanel.this, "History", urls);
            if (x != -1) {
                HTMLBrowserPanel.this.historyIndex = x;
                HTMLBrowserPanel.this.updateActionEnabling();
                HTMLBrowserPanel.this.setPageInternal((String)urls[x]);
            }
        }
    };
    private final Action actionRefresh = new AbstractInternationalizedAction("REFRESH", ResourceManager.bundle){

        public void actionPerformed(ActionEvent e) {
            if (HTMLBrowserPanel.this.history.size() == 0) {
                return;
            }
            HTMLBrowserPanel.this.setPageInternal((String)HTMLBrowserPanel.this.history.get(HTMLBrowserPanel.this.historyIndex));
        }
    };

    public HTMLBrowserPanel() {
        super(new BorderLayout());
        super.setMinimumSize(GUIUtils.HALF_SCREEN);
        super.setPreferredSize(GUIUtils.HALF_SCREEN);
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        this.tfAddress = new JTextField();
        this.tfAddress.addActionListener(this.actionGo);
        this.tfAddress.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                HTMLBrowserPanel.this.tfAddress.selectAll();
            }
        });
        toolBar.add(this.actionBack);
        toolBar.add(this.actionForward);
        toolBar.add(this.tfAddress);
        toolBar.add(this.actionGo);
        toolBar.add(this.actionRefresh);
        GUIUtils.setKeyStrokes(this, new Action[]{this.actionShowHistory, this.actionBack, this.actionForward, this.actionGo, this.actionRefresh});
        super.add((Component)toolBar, "North");
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        this.editorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                Object source;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (source = e.getSource()) instanceof JEditorPane) {
                    JEditorPane editorPane = (JEditorPane)source;
                    if (e instanceof HTMLFrameHyperlinkEvent) {
                        HTMLFrameHyperlinkEvent event = (HTMLFrameHyperlinkEvent)e;
                        HTMLDocument doc = (HTMLDocument)editorPane.getDocument();
                        doc.processHTMLFrameHyperlinkEvent(event);
                    } else {
                        HTMLBrowserPanel.this.setPageInternal(e.getURL().toExternalForm());
                    }
                }
            }
        });
        super.add((Component)new JScrollPane(this.editorPane), "Center");
        this.updateActionEnabling();
    }

    public void setPage(String url) {
        if (this.historyIndex < this.history.size() - 1) {
            this.history.setSize(this.historyIndex + 1);
        }
        ++this.historyIndex;
        this.history.add(url);
        this.updateActionEnabling();
        this.setPageInternal(url);
    }

    private void setPageInternal(String url) {
        this.tfAddress.setText(url);
        try {
            this.editorPane.setPage(url);
        }
        catch (IOException e1) {
            this.editorPane.setContentType("text/plain");
            this.editorPane.setText(e1.toString());
            XOptionsPane.showStacktraceDialog(this, e1);
        }
    }

    private void updateActionEnabling() {
        int nHistory = this.history.size();
        this.actionBack.setEnabled(this.historyIndex > 0);
        this.actionForward.setEnabled(this.historyIndex < nHistory - 1);
        this.actionShowHistory.setEnabled(nHistory > 0);
        this.actionRefresh.setEnabled(nHistory > 0);
    }

    public static void main(String[] args) throws Exception {
        HTMLBrowserPanel browserPanel = new HTMLBrowserPanel();
        browserPanel.setPage("file:/D:/Perforce/InQMy/AppServer/dev/src/server/com/sap/engine/services/apptracing/gui/help/index.html");
        GUIUtils.showInAFrame(browserPanel);
    }
}

