/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.cf;

import com.sap.engine.library.bytecode.cf.AbstractSwitchTable;
import com.sap.engine.library.bytecode.cf.CFFactory;
import com.sap.engine.library.bytecode.cf.Instruction;

public final class TableSwitchTable
extends AbstractSwitchTable {
    private int lowValue;
    private int highValue;

    TableSwitchTable(CFFactory factory) {
        super(factory);
    }

    void init(Instruction ownerInstruction, int lowValue, int highValue, String defaultBranchLabel, String[] branchLabels) {
        super.init0(ownerInstruction, defaultBranchLabel, branchLabels, highValue - lowValue + 1);
        this.lowValue = lowValue;
        this.highValue = highValue;
    }

    public int getHighValue() {
        return this.highValue;
    }

    public int getLowValue() {
        return this.lowValue;
    }

    public Instruction getBranchByKey(int key) {
        return key < this.lowValue || key > this.highValue ? this.getDefaultBranch() : this.getBranchByIndex(key - this.lowValue);
    }

    AbstractSwitchTable cloneAbstractSwitchTable(Instruction x, String labelPrefix) {
        return this.cloneTableSwitchTable(x, labelPrefix);
    }

    TableSwitchTable cloneTableSwitchTable(Instruction x, String labelPrefix) {
        TableSwitchTable r = new TableSwitchTable(this.getFactory());
        r.lowValue = this.lowValue;
        r.highValue = this.highValue;
        super.transferFields(r, x, labelPrefix);
        return r;
    }

    public String toString() {
        switch ((int)System.currentTimeMillis()) {
            case 4: {
                System.out.println("bla");
            }
            case 7: {
                System.out.println("alb");
            }
        }
        return "TableSwitchTable";
    }
}

