/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.cf;

import com.sap.engine.library.bytecode.cf.ClassFile;
import com.sap.engine.library.bytecode.cf.FieldInfo;
import com.sap.engine.library.bytecode.cf.MemberInfo;
import com.sap.engine.library.bytecode.cf.MethodInfo;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;

final class SerialVersionUIDCalculator {
    private static final Comparator MEMBER_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            String name1 = ((MemberInfo)o1).getName();
            String name2 = ((MemberInfo)o2).getName();
            return name1.compareTo(name2);
        }
    };
    private static final OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        public void write(int b) throws IOException {
        }

        public void write(byte[] b) throws IOException {
        }

        public void write(byte[] b, int off, int len) throws IOException {
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    };

    private SerialVersionUIDCalculator() {
    }

    protected static long computeSerialVersionUID(ClassFile cf) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA");
            DataOutputStream out = new DataOutputStream(new DigestOutputStream(NULL_OUTPUT_STREAM, digest));
            int cfAccessFlags = cf.getAccessFlags();
            cfAccessFlags &= 0x611;
            Object[] interfaceNames = cf.getInterfaceNames();
            int i = 0;
            while (i < interfaceNames.length) {
                interfaceNames[i] = ((String)interfaceNames[i]).replace('/', '.');
                ++i;
            }
            Arrays.sort(interfaceNames);
            FieldInfo[] fields = cf.getFieldsArray();
            Arrays.sort(fields, MEMBER_COMPARATOR);
            MethodInfo[] methods = cf.getMethodsArray();
            MethodInfo[] constructors = new MethodInfo[methods.length];
            int nConstructors = 0;
            int nMethods = methods.length;
            int index = 0;
            while (index < nMethods) {
                String name = methods[index].getName();
                if (name.equals("<init>")) {
                    constructors[nConstructors++] = methods[index];
                    methods[index] = methods[--nMethods];
                    continue;
                }
                if (name.equals("<clinit>")) {
                    methods[index] = methods[--nMethods];
                    continue;
                }
                ++index;
            }
            Arrays.sort(methods, 0, nMethods, MEMBER_COMPARATOR);
            Arrays.sort(constructors, 0, nConstructors, MEMBER_COMPARATOR);
            out.writeUTF(cf.getName().replace('/', '.'));
            if ((cfAccessFlags & 0x200) != 0) {
                cfAccessFlags &= 0xFFFFFBFF;
                if (methods.length > 0) {
                    cfAccessFlags |= 0x400;
                }
            }
            out.writeInt(cfAccessFlags);
            int i2 = 0;
            while (i2 < interfaceNames.length) {
                out.writeUTF((String)interfaceNames[i2]);
                ++i2;
            }
            int i3 = 0;
            while (i3 < fields.length) {
                FieldInfo f = fields[i3];
                int m = f.getAccessFlags();
                if (!Modifier.isPrivate(m) || !Modifier.isTransient(m) && !Modifier.isStatic(m)) {
                    out.writeUTF(f.getName());
                    out.writeInt(m);
                    out.writeUTF(f.getDescriptor());
                }
                ++i3;
            }
            if (cf.getMethod("<clinit>", "()V") != null) {
                out.writeUTF("<clinit>");
                out.writeInt(8);
                out.writeUTF("()V");
            }
            int i4 = 0;
            while (i4 < nConstructors) {
                if (!constructors[i4].isPrivate()) {
                    out.writeUTF("<init>");
                    out.writeInt(constructors[i4].getAccessFlags());
                    out.writeUTF(constructors[i4].getDescriptor().replace('/', '.'));
                }
                ++i4;
            }
            int i5 = 0;
            while (i5 < nMethods) {
                if (!methods[i5].isPrivate()) {
                    out.writeUTF(methods[i5].getName());
                    out.writeInt(methods[i5].getAccessFlags());
                    out.writeUTF(methods[i5].getDescriptor().replace('/', '.'));
                }
                ++i5;
            }
            out.flush();
            byte[] hasharray = digest.digest();
            int l = Math.min(8, hasharray.length);
            long h = 0L;
            int i6 = 0;
            while (i6 < l) {
                h += (long)(hasharray[i6] & 0xFF) << i6 * 8;
                ++i6;
            }
            return h;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return -1L;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SecurityException(nsae.getMessage());
        }
    }
}

