/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.cf;

import com.sap.engine.library.bytecode.cf.CFException;
import com.sap.engine.library.bytecode.cf.CFFactory;
import com.sap.engine.library.bytecode.cf.CPInfo;
import com.sap.engine.library.bytecode.cf.ClassFile;
import com.sap.engine.library.bytecode.cf.CodeAttribute;
import com.sap.engine.library.bytecode.cf.ExceptionsAttribute;
import com.sap.engine.library.bytecode.cf.FieldInfo;
import com.sap.engine.library.bytecode.cf.MemberInfo;
import com.sap.engine.library.bytecode.misc.StringUtils;

public final class MethodInfo
extends MemberInfo {
    private String returnType = null;
    private String[] arguments = null;
    private String jlsString = null;

    MethodInfo(CFFactory factory, ClassFile ownerClassFile, int accessFlags, CPInfo name, CPInfo descriptor) {
        super(factory, ownerClassFile, accessFlags, name, descriptor);
    }

    public String getReturnType() {
        if (this.returnType == null) {
            this.returnType = MethodInfo.parseMethodDescriptorReturnType(this.getDescriptor());
        }
        return this.returnType;
    }

    public String[] getArguments() {
        if (this.arguments == null) {
            this.arguments = MethodInfo.parseMethodDescriptorArguments(this.getDescriptor());
        }
        String[] r = new String[this.arguments.length];
        System.arraycopy(this.arguments, 0, r, 0, this.arguments.length);
        return r;
    }

    public String toString() {
        return "[METHOD " + this.getOwnerClassFile().getName() + '.' + this.getName() + this.getDescriptor() + "]";
    }

    public CodeAttribute getCodeAttribute() {
        CodeAttribute r;
        try {
            r = (CodeAttribute)super.getAttribute("Code");
        }
        catch (ClassCastException cce) {
            throw new CFException(22);
        }
        return r;
    }

    public CodeAttribute createCodeAttribute() {
        CodeAttribute ca = this.getCodeAttribute();
        if (ca != null) {
            return ca;
        }
        ca = new CodeAttribute(this.factory, this);
        super.addAttribute(ca);
        return ca;
    }

    public ExceptionsAttribute getExceptionsAttribute() {
        return (ExceptionsAttribute)super.getAttribute("Exceptions");
    }

    public ExceptionsAttribute createExceptionsAttribute() {
        ExceptionsAttribute r = this.getExceptionsAttribute();
        if (r != null) {
            return r;
        }
        r = new ExceptionsAttribute();
        super.addAttribute(r);
        return r;
    }

    public static String[] parseMethodDescriptorArguments(String s) {
        int i = 1;
        String[] temp = new String[s.length()];
        int nTemp = 0;
        block6: while (true) {
            int j = i;
            while (s.charAt(j) == '[') {
                ++j;
            }
            switch (s.charAt(j)) {
                case ')': {
                    break block6;
                }
                case 'L': {
                    j = s.indexOf(59, j) + 1;
                    break;
                }
                default: {
                    ++j;
                }
            }
            temp[nTemp++] = s.substring(i, j);
            i = j;
        }
        String[] r = new String[nTemp];
        System.arraycopy(temp, 0, r, 0, nTemp);
        return r;
    }

    public static String parseMethodDescriptorReturnType(String s) {
        return s.substring(s.indexOf(41) + 1);
    }

    public static void checkMethodDescriptor(String s) {
        if (s == null) {
            throw new CFException(23);
        }
        int indexOfClosingBracket = s.indexOf(41);
        if (indexOfClosingBracket == -1) {
            throw new CFException(24, s);
        }
        MethodInfo.checkMethodParameters(s.substring(0, ++indexOfClosingBracket));
        MethodInfo.checkMethodReturnType(s.substring(indexOfClosingBracket));
    }

    public static void checkMethodParameters(String s) {
        if (s == null) {
            throw new CFException(30);
        }
        if (!s.startsWith("(")) {
            throw new CFException(31, s);
        }
        int indexOfClosingBracket = s.indexOf(41);
        int index = 1;
        int dimensions = 0;
        int slots = 0;
        while (index < indexOfClosingBracket) {
            switch (s.charAt(index)) {
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    ++index;
                    ++slots;
                    dimensions = 0;
                    break;
                }
                case 'D': 
                case 'J': {
                    ++index;
                    slots += dimensions == 0 ? 2 : 1;
                    dimensions = 0;
                    break;
                }
                case 'L': {
                    index = s.indexOf(59, index);
                    if (index == -1) {
                        throw new CFException(29, s);
                    }
                    ++index;
                    ++slots;
                    dimensions = 0;
                    break;
                }
                case '[': {
                    ++dimensions;
                    ++index;
                    break;
                }
                default: {
                    throw new CFException(27, new Object[]{s, new Character(s.charAt(index)), new Integer(index)});
                }
            }
        }
        if (index != indexOfClosingBracket) {
            throw new CFException(28, s);
        }
        if (dimensions != 0) {
            throw new CFException(26, s);
        }
        if (slots > 255) {
            throw new CFException(25, s);
        }
    }

    public static void checkMethodReturnType(String s) {
        if ("V".equals(s)) {
            return;
        }
        try {
            FieldInfo.checkFieldDescriptor(s);
        }
        catch (CFException cfe) {
            throw new CFException(3, s);
        }
    }

    public int getNInitialOccupiedLocalVariables() {
        int r = this.isStatic() ? 0 : 1;
        this.getArguments();
        int i = 0;
        while (i < this.arguments.length) {
            r += this.arguments[i].equals("J") || this.arguments[i].equals("D") ? 2 : 1;
            ++i;
        }
        return r;
    }

    public static String convertParametersToJLS(String parametersDescriptor) {
        MethodInfo.checkMethodParameters(parametersDescriptor);
        String[] arguments = MethodInfo.parseMethodDescriptorArguments(parametersDescriptor);
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        int i = 0;
        while (i < arguments.length) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(FieldInfo.convertTypeToJLS(arguments[i]));
            ++i;
        }
        buffer.append(")");
        return buffer.toString();
    }

    public String toJLSString() {
        boolean isConstructor;
        if (this.jlsString != null) {
            return this.jlsString;
        }
        String name = this.getName();
        if (name.equals("<clinit>")) {
            this.jlsString = "static { ... }";
            return this.jlsString;
        }
        String descriptor = this.getDescriptor();
        String[] parameters = MethodInfo.parseMethodDescriptorArguments(descriptor);
        String returnType = MethodInfo.parseMethodDescriptorReturnType(descriptor);
        StringBuffer buffer = new StringBuffer();
        if (name.equals("<init>")) {
            String className = this.getOwnerClassFile().getName();
            String[] a = StringUtils.split(className, '/');
            className = a[a.length - 1];
            buffer.append(className);
            isConstructor = true;
        } else {
            buffer.append(name);
            isConstructor = false;
        }
        buffer.append('(');
        int i = 0;
        while (i < parameters.length) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(FieldInfo.convertTypeToJLS(parameters[i]));
            ++i;
        }
        buffer.append(')');
        if (!isConstructor) {
            buffer.append(" : ");
            if (returnType.equals("V")) {
                buffer.append("void ");
            } else {
                buffer.append(FieldInfo.convertTypeToJLS(returnType)).append(' ');
            }
        }
        this.jlsString = buffer.toString();
        return this.jlsString;
    }
}

