/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.cf;

import com.sap.engine.library.bytecode.cf.AttributeContainer;
import com.sap.engine.library.bytecode.cf.AttributeInfo;
import com.sap.engine.library.bytecode.cf.Attributed;
import com.sap.engine.library.bytecode.cf.CFException;
import com.sap.engine.library.bytecode.cf.CFFactory;
import com.sap.engine.library.bytecode.cf.CFNode;
import com.sap.engine.library.bytecode.cf.CPInfo;
import com.sap.engine.library.bytecode.cf.ClassFile;
import com.sap.engine.library.bytecode.cf.FieldInfo;
import com.sap.engine.library.bytecode.cf.MethodInfo;
import com.sap.engine.library.bytecode.cf.SyntheticAttribute;
import com.sap.engine.library.bytecode.misc.Debug;

public abstract class MemberInfo
extends CFNode
implements Attributed {
    private static final int ACC_PUBLIC_PROTECTED_PRIVATE_MASK = -8;
    protected CFFactory factory;
    private ClassFile ownerClassFile;
    private int accessFlags;
    private CPInfo name;
    private CPInfo descriptor;
    private AttributeContainer attributeContainer = new AttributeContainer();

    MemberInfo(CFFactory factory, ClassFile ownerClassFile, int accessFlags, CPInfo name, CPInfo descriptor) {
        if (Debug.DEBUG_CF) {
            if (name == null || descriptor == null || descriptor.getTag() != 1) {
                throw new CFException(14);
            }
            if (this instanceof MethodInfo) {
                MethodInfo.checkMethodDescriptor(descriptor.getString());
            } else {
                FieldInfo.checkFieldDescriptor(descriptor.getString());
            }
        }
        this.factory = factory;
        this.ownerClassFile = ownerClassFile;
        this.accessFlags = accessFlags;
        this.name = name;
        this.descriptor = descriptor;
    }

    public final int getAccessFlags() {
        return this.accessFlags;
    }

    public final CPInfo getNameCPInfo() {
        return this.name;
    }

    public final String getName() {
        return this.name.toPlainString();
    }

    public final CPInfo getDescriptorCPInfo() {
        return this.descriptor;
    }

    public final String getDescriptor() {
        return this.descriptor.toPlainString();
    }

    public final ClassFile getOwnerClassFile() {
        return this.ownerClassFile;
    }

    public final boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    public final boolean isProtected() {
        return (this.accessFlags & 4) != 0;
    }

    public final boolean isPrivate() {
        return (this.accessFlags & 2) != 0;
    }

    public final boolean isStatic() {
        return (this.accessFlags & 8) != 0;
    }

    public final boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public final boolean isVolatile() {
        return (this.accessFlags & 0x40) != 0;
    }

    public final boolean isTransient() {
        return (this.accessFlags & 0x80) != 0;
    }

    public final boolean isSynchronized() {
        return (this.accessFlags & 0x20) != 0;
    }

    public final boolean isNative() {
        return (this.accessFlags & 0x100) != 0;
    }

    public final boolean isStrictFP() {
        return (this.accessFlags & 0x800) != 0;
    }

    public final void setPublic(boolean b) {
        this.accessFlags &= 0xFFFFFFF8;
        if (b) {
            this.accessFlags |= 1;
        }
    }

    public final void setProtected(boolean b) {
        this.accessFlags &= 0xFFFFFFF8;
        if (b) {
            this.accessFlags |= 4;
        }
    }

    public final void setPrivate(boolean b) {
        this.accessFlags &= 0xFFFFFFF8;
        if (b) {
            this.accessFlags |= 2;
        }
    }

    public final void setStatic(boolean b) {
        this.accessFlags = b ? (this.accessFlags |= 8) : (this.accessFlags &= 0xFFFFFFF7);
    }

    public final void setFinal(boolean b) {
        this.accessFlags = b ? (this.accessFlags |= 0x10) : (this.accessFlags &= 0xFFFFFFEF);
    }

    public final void setVolatile(boolean b) {
        this.accessFlags = b ? (this.accessFlags |= 0x40) : (this.accessFlags &= 0xFFFFFFBF);
    }

    public final void setTransient(boolean b) {
        this.accessFlags = b ? (this.accessFlags |= 0x80) : (this.accessFlags &= 0xFFFFFF7F);
    }

    public final void setSynchronized(boolean b) {
        this.accessFlags = b ? (this.accessFlags |= 0x20) : (this.accessFlags &= 0xFFFFFFDF);
    }

    public final void setNative(boolean b) {
        this.accessFlags = b ? (this.accessFlags |= 0x100) : (this.accessFlags &= 0xFFFFFEFF);
    }

    public final void setStrictFP(boolean b) {
        this.accessFlags = b ? (this.accessFlags |= 0x800) : (this.accessFlags &= 0xFFFFF7FF);
    }

    public final void setAccessFlags(int flags) {
        this.accessFlags = flags;
    }

    public final void addAttribute(AttributeInfo a) {
        this.ownerClassFile.createCPInfoUtf8(a.getName());
        this.attributeContainer.addAttribute(a);
    }

    public final int getNAttributes() {
        return this.attributeContainer.getNAttributes();
    }

    public final AttributeInfo getAttribute(int index) {
        return this.attributeContainer.getAttribute(index);
    }

    public final AttributeInfo getAttribute(String name) {
        return this.attributeContainer.getAttribute(name);
    }

    public final AttributeInfo[] getAttributesArray() {
        return this.attributeContainer.getAttributesArray();
    }

    public final void removeAttribute(String name) {
        this.attributeContainer.removeAttribute(name);
    }

    public final void removeAttribute(AttributeInfo a) {
        this.attributeContainer.removeAttribute(a);
    }

    public final CFNode getParentNode() {
        return this.ownerClassFile;
    }

    public final CFNode[] getChildNodes() {
        return this.getAttributesArray();
    }

    public final SyntheticAttribute getSyntheticAttribute() {
        return (SyntheticAttribute)this.attributeContainer.getAttribute("Synthetic");
    }

    public final void createSyntheticAttribute() {
        this.ownerClassFile.createCPInfoUtf8("Synthetic");
        if (this.getSyntheticAttribute() == null) {
            this.attributeContainer.addAttribute(new SyntheticAttribute());
        }
    }

    public final void removeSyntheticAttribute() {
        SyntheticAttribute a = this.getSyntheticAttribute();
        if (a != null) {
            this.attributeContainer.removeAttribute(a);
        }
    }
}

