/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.cf;

import com.sap.engine.library.bytecode.cf.AbstractSwitchTable;
import com.sap.engine.library.bytecode.cf.CFFactory;
import com.sap.engine.library.bytecode.cf.Instruction;

public final class LookupSwitchTable
extends AbstractSwitchTable {
    private int[] matches;

    LookupSwitchTable(CFFactory factory) {
        super(factory);
    }

    void init(Instruction ownerInstruction, String defaultBranchLabel, int[] matches, String[] branchLabels, int nBranches) {
        super.init0(ownerInstruction, defaultBranchLabel, branchLabels, nBranches);
        this.matches = new int[nBranches];
        System.arraycopy(matches, 0, this.matches, 0, nBranches);
    }

    public int getMatch(int index) {
        return this.matches[index];
    }

    public int[] getMatchesArray() {
        int n = this.getNBranches();
        int[] r = new int[n];
        System.arraycopy(this.matches, 0, r, 0, n);
        return r;
    }

    public Instruction getBranchByKey(int key) {
        int i = 0;
        while (i < this.getNBranches()) {
            if (key == this.matches[i]) {
                return this.getBranchByIndex(i);
            }
            ++i;
        }
        return this.getDefaultBranch();
    }

    AbstractSwitchTable cloneAbstractSwitchTable(Instruction x, String labelPrefix) {
        return this.cloneLookupSwitchTable(x, labelPrefix);
    }

    LookupSwitchTable cloneLookupSwitchTable(Instruction x, String labelPrefix) {
        LookupSwitchTable r = new LookupSwitchTable(this.getFactory());
        r.matches = new int[this.matches.length];
        System.arraycopy(this.matches, 0, r.matches, 0, this.matches.length);
        super.transferFields(r, x, labelPrefix);
        return r;
    }

    public String toString() {
        return "LookupSwitchTable";
    }
}

